/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OsmWaterModeTags {
    private static final Set<String> MODE_TAGS = new HashSet<String>();
    public static final String FERRY = "ferry";

    private static void populateModeTags() {
        MODE_TAGS.add(FERRY);
    }

    public static boolean isWaterModeTag(String modeTag) {
        return MODE_TAGS.contains(modeTag);
    }

    public static Set<String> getSupportedWaterModeTags() {
        return Collections.unmodifiableSet(MODE_TAGS);
    }

    public static String[] getSupportedWaterModeTagsAsArray() {
        return MODE_TAGS.toArray(new String[MODE_TAGS.size()]);
    }

    public static boolean containsAnyMode(Collection<String> osmModes) {
        return !Collections.disjoint(MODE_TAGS, osmModes);
    }

    public static Collection<String> getModesFrom(Collection<String> eligibleOsmModes) {
        HashSet<String> intersectionModes = new HashSet<String>(eligibleOsmModes);
        intersectionModes.retainAll(MODE_TAGS);
        return intersectionModes;
    }

    public static Collection<String> getPublicTransportModesFrom(Collection<String> eligibleOsmModes) {
        return OsmWaterModeTags.getModesFrom(eligibleOsmModes);
    }

    static {
        OsmWaterModeTags.populateModeTags();
    }
}

