/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.util.OsmPtVersionScheme;

public class OsmPtVersionSchemeUtils {
    static final Logger LOGGER = Logger.getLogger(OsmPtVersionSchemeUtils.class.getCanonicalName());

    public static boolean isCompatibleWith(OsmPtVersionScheme scheme, Map<String, String> tags) {
        if (scheme.equals((Object)OsmPtVersionScheme.VERSION_1)) {
            if (OsmHighwayTags.hasHighwayKeyTag(tags) || OsmRailwayTags.hasRailwayKeyTag(tags)) {
                return OsmPtv1Tags.hasPtv1ValueTag(tags);
            }
        } else {
            if (scheme.equals((Object)OsmPtVersionScheme.VERSION_2)) {
                return OsmPtv2Tags.hasPtv2ValueTag(tags);
            }
            LOGGER.severe(String.format("unknown OSM public transport scheme %s provided to check compatibility with, ignored", scheme.value()));
        }
        return false;
    }

    public static OsmPtVersionScheme isPublicTransportBasedInfrastructure(Map<String, String> tags) {
        if (OsmPtVersionSchemeUtils.isCompatibleWith(OsmPtVersionScheme.VERSION_2, tags)) {
            return OsmPtVersionScheme.VERSION_2;
        }
        if (OsmPtVersionSchemeUtils.isCompatibleWith(OsmPtVersionScheme.VERSION_1, tags)) {
            return OsmPtVersionScheme.VERSION_1;
        }
        return OsmPtVersionScheme.NONE;
    }

    public static boolean isPtv2StopPositionPtv1Stop(OsmNode osmNode, Map<String, String> tags) {
        if (OsmPtv1Tags.isTramStop(tags)) {
            LOGGER.fine(String.format("Identified Ptv1 tram_stop (%d) that is also tagged as Ptv2 public_transport=stop_location", osmNode.getId()));
            return true;
        }
        if (OsmPtv1Tags.isBusStop(tags)) {
            LOGGER.fine(String.format("Identified Ptv1 bus_stop (%d) that is also tagged as Ptv2 public_transport=stop_location", osmNode.getId()));
            return true;
        }
        if (OsmPtv1Tags.isHalt(tags)) {
            LOGGER.fine(String.format("Identified Ptv1 halt (%d) that is also tagged as Ptv2 public_transport=stop_location", osmNode.getId()));
            return true;
        }
        if (OsmPtv1Tags.isStation(tags)) {
            LOGGER.fine(String.format("Identified Ptv1 station (%d) that is also tagged as Ptv2 public_transport=stop_location", osmNode.getId()));
            return true;
        }
        return false;
    }
}

