/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;

public class PlanitLinkSegmentUtils {
    public static MacroscopicLinkSegment getLinkSegmentIfLinkIsOneWayForMode(Link link, Mode accessMode) {
        Object edgeSegment = null;
        if (link.hasEdgeSegmentAb() != link.hasEdgeSegmentBa()) {
            edgeSegment = (link.hasEdgeSegmentAb() ? link.getLinkSegmentAb() : link.getLinkSegmentBa());
        } else if (((MacroscopicLinkSegment)link.getLinkSegmentAb()).isModeAllowed(accessMode) != ((MacroscopicLinkSegment)link.getLinkSegmentBa()).isModeAllowed(accessMode)) {
            edgeSegment = (((MacroscopicLinkSegment)link.getLinkSegmentAb()).isModeAllowed(accessMode) ? link.getLinkSegmentAb() : link.getLinkSegmentBa());
        }
        return edgeSegment;
    }

    public static LineSegment extractClosestLineSegmentToGeometryFromLinkSegment(Geometry referenceGeometry, MacroscopicLinkSegment linkSegment, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        LineString linkSegmentGeometry = linkSegment.getParentEdge().getGeometry();
        if (linkSegmentGeometry == null) {
            throw new PlanItException("geometry not available on osm way %s, unable to determine if link (segment) is closest to reference geometry, this shouldn't happen", linkSegment.getParentEdge().getExternalId());
        }
        LinearLocation linearLocation = geoUtils.getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(referenceGeometry, linkSegmentGeometry);
        boolean reverseLinearLocationGeometry = linkSegment.isDirectionAb() != linkSegment.getParentEdge().isGeometryInAbDirection();
        LineSegment lineSegment = linearLocation.getSegment(linkSegment.getParentEdge().getGeometry());
        if (reverseLinearLocationGeometry) {
            lineSegment.reverse();
        }
        return lineSegment;
    }
}

