/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import java.util.Collection;
import java.util.HashSet;
import org.goplanit.osm.util.PlanitLinkSegmentUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Link;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;

public class PlanitLinkUtils {
    public static Collection<Link> excludeLinksOnWrongSideOf(Geometry waitingAreaGeometry, Collection<Link> links, boolean isLeftHandDrive, Collection<Mode> accessModes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        HashSet<Link> matchedLinks = new HashSet<Link>(links);
        block0: for (Link link : links) {
            for (Mode accessMode : accessModes) {
                MacroscopicLinkSegment oneWayLinkSegment;
                boolean mustAvoidCrossingTraffic = true;
                if (accessMode.getPhysicalFeatures().getTrackType().equals((Object)TrackModeType.RAIL)) {
                    mustAvoidCrossingTraffic = false;
                }
                if ((oneWayLinkSegment = PlanitLinkSegmentUtils.getLinkSegmentIfLinkIsOneWayForMode(link, accessMode)) == null || !mustAvoidCrossingTraffic) continue;
                LineSegment finalLineSegment = PlanitLinkSegmentUtils.extractClosestLineSegmentToGeometryFromLinkSegment(waitingAreaGeometry, oneWayLinkSegment, geoUtils);
                boolean isStationLeftOfOneWayLinkSegment = geoUtils.isGeometryLeftOf(waitingAreaGeometry, finalLineSegment.p0, finalLineSegment.p1);
                if (isStationLeftOfOneWayLinkSegment == isLeftHandDrive) continue;
                matchedLinks.remove(link);
                continue block0;
            }
        }
        return matchedLinks;
    }

    public static Link getClosestLinkWithOsmWayIdToGeometry(long osmWayId, Geometry geometry, MacroscopicNetworkLayer networkLayer, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Collection nominatedLinks = networkLayer.getLinks().getByExternalId(String.valueOf(osmWayId));
        return (Link)PlanitGraphGeoUtils.findEdgeClosest(geometry, nominatedLinks, geoUtils);
    }
}

