/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkToZoningReaderData;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.network.layer.TransportLayer;

public class PlanitNetworkLayerUtils {
    public static boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId, TransportLayerNetwork<?, ?> network, OsmNetworkToZoningReaderData networkToZoningData) throws PlanItException {
        OsmNode osmNode = networkToZoningData.getOsmNodes().get(osmNodeId);
        if (osmNode != null) {
            for (TransportLayer networkLayer : network.getTransportLayers()) {
                if (!networkToZoningData.getNetworkLayerData(networkLayer).isOsmNodePresentInLayer(osmNode)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId, TransportLayerNetwork<?, ?> network, OsmNetworkReaderData networkData) throws PlanItException {
        OsmNode osmNode = networkData.getOsmNode(osmNodeId);
        if (osmNode != null) {
            for (TransportLayer networkLayer : network.getTransportLayers()) {
                OsmNetworkLayerParser layerHandler = networkData.getLayerParser((MacroscopicNetworkLayerImpl)networkLayer);
                if (!layerHandler.getLayerData().isOsmNodePresentInLayer(osmNode)) continue;
                return true;
            }
        }
        return false;
    }
}

