/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.MacroscopicLinkOutputTypeAdapter;
import org.goplanit.output.adapter.UntypedLinkOutputTypeAdapterImpl;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;
import org.goplanit.utils.time.TimePeriod;

public abstract class MacroscopicLinkOutputTypeAdapterImpl
extends UntypedLinkOutputTypeAdapterImpl<MacroscopicLinkSegment>
implements MacroscopicLinkOutputTypeAdapter {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkOutputTypeAdapterImpl.class.getCanonicalName());

    public MacroscopicLinkOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<Long> getInfrastructureLayerIdForMode(Mode mode) {
        Object networkLayer = this.getAssignment().getTransportNetwork().getInfrastructureNetwork().getLayerByMode(mode);
        return Optional.of(networkLayer != null ? Long.valueOf(networkLayer.getId()) : null);
    }

    public MacroscopicLinkSegments getPhysicalLinkSegments(long infrastructureLayerId) {
        TransportLayer networkLayer = (TransportLayer)this.getAssignment().getTransportNetwork().getInfrastructureNetwork().getTransportLayers().get(infrastructureLayerId);
        if (networkLayer instanceof MacroscopicNetworkLayer) {
            return ((MacroscopicNetworkLayer)networkLayer).getLinkSegments();
        }
        LOGGER.warning(String.format("Cannot collect macroscopic physical link segments from infrastructure layer %s, as it is not a macroscopic physical network layer", networkLayer.getXmlId()));
        return null;
    }

    @Override
    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty outputProperty, MacroscopicLinkSegment linkSegment, Mode mode, TimePeriod timePeriod) {
        try {
            Optional<?> value = super.getOutputTypeIndependentPropertyValue(outputProperty, mode, timePeriod);
            if (value.isPresent()) {
                return value;
            }
            value = super.getLinkSegmentOutputPropertyValue(outputProperty, linkSegment);
            if (value.isPresent()) {
                return value;
            }
            switch (outputProperty.getOutputPropertyType()) {
                case CAPACITY_PER_LANE: {
                    return this.getCapacityPerLanePcuHour(linkSegment);
                }
                case MAXIMUM_DENSITY: {
                    return this.getMaximumDensity(linkSegment);
                }
                case MAXIMUM_SPEED: {
                    return this.getMaximumSpeed(linkSegment, mode);
                }
                case LINK_SEGMENT_TYPE_NAME: {
                    return this.getLinkSegmentTypeName(linkSegment);
                }
                case LINK_SEGMENT_TYPE_ID: {
                    return this.getLinkSegmentTypeId(linkSegment);
                }
                case LINK_SEGMENT_TYPE_XML_ID: {
                    return this.getLinkSegmentTypeXmlId(linkSegment);
                }
            }
            return Optional.empty();
        }
        catch (PlanItException e) {
            return Optional.of(e.getMessage());
        }
    }
}

