/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Point;

public interface UntypedLinkOutputTypeAdapter<T extends LinkSegment>
extends OutputTypeAdapter {
    public static Optional<String> getVertexLocationAsString(Vertex vertex) {
        Point position = vertex.getPosition();
        if (position == null) {
            return Optional.of("Not Specified");
        }
        return Optional.of(position.getCoordinate().x + "-" + position.getCoordinate().y);
    }

    default public Optional<String> getDownstreamNodeExternalId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getDownstreamVertex().getExternalId());
    }

    default public Optional<String> getDownstreamNodeXmlId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getDownstreamVertex().getXmlId());
    }

    default public Optional<Long> getDownstreamNodeId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getDownstreamVertex().getId());
    }

    default public Optional<String> getDownstreamNodeLocation(T linkSegment) throws PlanItException {
        Node downstreamVertex = linkSegment.getDownstreamVertex();
        return UntypedLinkOutputTypeAdapter.getVertexLocationAsString(downstreamVertex);
    }

    default public Optional<Double> getLength(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getParentLink().getLengthKm());
    }

    default public Optional<String> getLinkSegmentExternalId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getExternalId());
    }

    default public Optional<String> getLinkSegmentXmlId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getXmlId());
    }

    default public Optional<Long> getLinkSegmentId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getId());
    }

    default public Optional<Integer> getNumberOfLanes(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getNumberOfLanes());
    }

    default public Optional<String> getUpstreamNodeExternalId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getUpstreamVertex().getExternalId());
    }

    default public Optional<String> getUpstreamNodeXmlId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getUpstreamVertex().getXmlId());
    }

    default public Optional<String> getUpstreamNodeLocation(T linkSegment) throws PlanItException {
        Node upstreamVertex = linkSegment.getUpstreamVertex();
        return UntypedLinkOutputTypeAdapter.getVertexLocationAsString(upstreamVertex);
    }

    default public Optional<Long> getUpstreamNodeId(T linkSegment) throws PlanItException {
        return Optional.of(linkSegment.getUpstreamVertex().getId());
    }

    public GraphEntities<T> getPhysicalLinkSegments(long var1);

    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty var1, T var2);
}

