/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.property;

import java.util.logging.Logger;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;

public enum OutputPropertyType {
    DENSITY("org.goplanit.output.property.DensityOutputProperty"),
    LINK_SEGMENT_ID("org.goplanit.output.property.LinkSegmentIdOutputProperty"),
    LINK_SEGMENT_XML_ID("org.goplanit.output.property.LinkSegmentXmlIdOutputProperty"),
    LINK_SEGMENT_EXTERNAL_ID("org.goplanit.output.property.LinkSegmentExternalIdOutputProperty"),
    MODE_ID("org.goplanit.output.property.ModeIdOutputProperty"),
    MODE_EXTERNAL_ID("org.goplanit.output.property.ModeExternalIdOutputProperty"),
    MODE_XML_ID("org.goplanit.output.property.ModeXmlIdOutputProperty"),
    MAXIMUM_DENSITY("org.goplanit.output.property.MaximumDensityOutputProperty"),
    MAXIMUM_SPEED("org.goplanit.output.property.MaximumSpeedOutputProperty"),
    CALCULATED_SPEED("org.goplanit.output.property.CalculatedSpeedOutputProperty"),
    FLOW("org.goplanit.output.property.FlowOutputProperty"),
    INFLOW("org.goplanit.output.property.InflowOutputProperty"),
    OUTFLOW("org.goplanit.output.property.OutflowOutputProperty"),
    LENGTH("org.goplanit.output.property.LengthOutputProperty"),
    UPSTREAM_NODE_ID("org.goplanit.output.property.UpstreamNodeIdOutputProperty"),
    UPSTREAM_NODE_EXTERNAL_ID("org.goplanit.output.property.UpstreamNodeExternalIdOutputProperty"),
    UPSTREAM_NODE_XML_ID("org.goplanit.output.property.UpstreamNodeXmlIdOutputProperty"),
    DOWNSTREAM_NODE_ID("org.goplanit.output.property.DownstreamNodeIdOutputProperty"),
    DOWNSTREAM_NODE_EXTERNAL_ID("org.goplanit.output.property.DownstreamNodeExternalIdOutputProperty"),
    DOWNSTREAM_NODE_XML_ID("org.goplanit.output.property.DownstreamNodeXmlIdOutputProperty"),
    CAPACITY_PER_LANE("org.goplanit.output.property.CapacityPerLaneOutputProperty"),
    NUMBER_OF_LANES("org.goplanit.output.property.NumberOfLanesOutputProperty"),
    LINK_SEGMENT_COST("org.goplanit.output.property.LinkSegmentCostOutputProperty"),
    OD_COST("org.goplanit.output.property.OdCostOutputProperty"),
    DOWNSTREAM_NODE_LOCATION("org.goplanit.output.property.DownstreamNodeLocationOutputProperty"),
    UPSTREAM_NODE_LOCATION("org.goplanit.output.property.UpstreamNodeLocationOutputProperty"),
    ITERATION_INDEX("org.goplanit.output.property.IterationIndexOutputProperty"),
    ORIGIN_ZONE_ID("org.goplanit.output.property.OriginZoneIdOutputProperty"),
    ORIGIN_ZONE_EXTERNAL_ID("org.goplanit.output.property.OriginZoneExternalIdOutputProperty"),
    ORIGIN_ZONE_XML_ID("org.goplanit.output.property.OriginZoneXmlIdOutputProperty"),
    DESTINATION_ZONE_ID("org.goplanit.output.property.DestinationZoneIdOutputProperty"),
    DESTINATION_ZONE_XML_ID("org.goplanit.output.property.DestinationZoneXmlIdOutputProperty"),
    DESTINATION_ZONE_EXTERNAL_ID("org.goplanit.output.property.DestinationZoneExternalIdOutputProperty"),
    TIME_PERIOD_ID("org.goplanit.output.property.TimePeriodIdOutputProperty"),
    TIME_PERIOD_XML_ID("org.goplanit.output.property.TimePeriodXmlIdOutputProperty"),
    TIME_PERIOD_EXTERNAL_ID("org.goplanit.output.property.TimePeriodExternalIdOutputProperty"),
    RUN_ID("org.goplanit.output.property.RunIdOutputProperty"),
    PATH_STRING("org.goplanit.output.property.PathOutputStringProperty"),
    PATH_ID("org.goplanit.output.property.PathIdOutputProperty"),
    VC_RATIO("org.goplanit.output.property.VCRatioOutputProperty"),
    COST_TIMES_FLOW("org.goplanit.output.property.CostTimesFlowOutputProperty"),
    LINK_SEGMENT_TYPE_ID("org.goplanit.output.property.LinkSegmentTypeIdOutputProperty"),
    LINK_SEGMENT_TYPE_NAME("org.goplanit.output.property.LinkSegmentTypeNameOutputProperty"),
    LINK_SEGMENT_TYPE_XML_ID("org.goplanit.output.property.LinkSegmentTypeXmlIdOutputProperty");

    private static final Logger LOGGER;
    private final String value;

    private OutputPropertyType(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static OutputPropertyType fromValue(String value) {
        for (OutputPropertyType outputProperty : OutputPropertyType.values()) {
            if (!outputProperty.value.equals(value)) continue;
            return outputProperty;
        }
        throw new IllegalArgumentException(value);
    }

    public static OutputPropertyType fromHeaderName(String name) throws PlanItException {
        String strippedName = name.stripLeading().stripTrailing();
        try {
            for (OutputPropertyType outputProperty : OutputPropertyType.values()) {
                Class<?> entityClass = Class.forName(outputProperty.value);
                OutputProperty baseOutputProperty = (OutputProperty)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!baseOutputProperty.getName().equals(strippedName)) continue;
                return outputProperty;
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(e);
        }
        throw new PlanItException("The header name " + strippedName + " is not associated with any output property");
    }

    static {
        LOGGER = Logger.getLogger(OutputPropertyType.class.getCanonicalName());
    }
}

