/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.path;

import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;
import org.goplanit.component.PlanitComponent;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.zoning.Zoning;

public class OdPathSets
extends PlanitComponent<OdPathSets>
implements Serializable {
    private static final long serialVersionUID = -8742549499023004121L;
    protected final TreeMap<Long, OdPathMatrix> odPathMatrices;

    public OdPathSets(IdGroupingToken groupId) {
        super(groupId, OdPathSets.class);
        this.odPathMatrices = new TreeMap();
    }

    public OdPathSets(OdPathSets other) {
        super(other);
        this.odPathMatrices = new TreeMap<Long, OdPathMatrix>((SortedMap<Long, OdPathMatrix>)other.odPathMatrices);
    }

    public int getNumberOfOdPathSets() {
        return this.odPathMatrices.size();
    }

    public OdPathMatrix createAndRegisterOdPathMatrix(Zoning zoning) {
        OdPathMatrix newOdPathMatrix = new OdPathMatrix(this.getIdGroupingToken(), zoning.odZones);
        this.odPathMatrices.put(newOdPathMatrix.getId(), newOdPathMatrix);
        return newOdPathMatrix;
    }

    public void registerOdPathMatrix(OdPathMatrix odPathMatrix) {
        this.odPathMatrices.put(odPathMatrix.getId(), odPathMatrix);
    }

    public Boolean hasRegisteredOdMatrices() {
        return !this.odPathMatrices.isEmpty();
    }

    public OdPathMatrix getFirstOdPathMatrix() {
        return this.hasRegisteredOdMatrices() != false ? this.odPathMatrices.firstEntry().getValue() : null;
    }

    @Override
    public OdPathSets clone() {
        return new OdPathSets(this);
    }

    @Override
    public void reset() {
        this.odPathMatrices.clear();
    }
}

