/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.project;

import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.assignment.TrafficAssignmentBuilder;
import org.goplanit.assignment.TrafficAssignmentBuilderFactory;
import org.goplanit.assignment.TrafficAssignmentConfigurator;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.PlanitComponentFactory;
import org.goplanit.cost.physical.initial.InitialLinkSegmentCost;
import org.goplanit.demands.Demands;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.output.formatter.OutputFormatter;
import org.goplanit.output.formatter.OutputFormatterFactory;
import org.goplanit.path.OdPathSets;
import org.goplanit.project.PlanItProjectInput;
import org.goplanit.project.ProjectAssignmentBuilders;
import org.goplanit.project.ProjectDemands;
import org.goplanit.project.ProjectNetworks;
import org.goplanit.project.ProjectOdPathSets;
import org.goplanit.project.ProjectRoutedServices;
import org.goplanit.project.ProjectServiceNetworks;
import org.goplanit.project.ProjectZonings;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class CustomPlanItProject {
    private static final Logger LOGGER = Logger.getLogger(CustomPlanItProject.class.getCanonicalName());
    protected final long id;
    protected IdGroupingToken projectToken;
    protected final PlanItProjectInput inputs;
    protected final InputBuilderListener inputBuilderListener;
    protected final ProjectAssignmentBuilders assignmentBuilders = new ProjectAssignmentBuilders();
    protected final TreeMap<Long, OutputFormatter> outputFormatters;
    public final ProjectNetworks physicalNetworks;
    public final ProjectDemands demands;
    public final ProjectZonings zonings;
    public final ProjectOdPathSets odPathSets;
    public final ProjectServiceNetworks serviceNetworks;
    public final ProjectRoutedServices routedServices;

    protected void executeTrafficAssignment(TrafficAssignment ta) {
        try {
            ta.execute();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    public CustomPlanItProject(InputBuilderListener inputBuilderListener) {
        this.id = IdGenerator.generateId(IdGroupingToken.collectGlobalToken(), CustomPlanItProject.class);
        this.projectToken = IdGenerator.createIdGroupingToken(this, this.id);
        this.inputBuilderListener = inputBuilderListener;
        LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.logActiveStateByClassName(inputBuilderListener, true));
        this.inputs = new PlanItProjectInput(this.id, this.projectToken, inputBuilderListener);
        this.physicalNetworks = this.inputs.physicalNetworks;
        this.demands = this.inputs.demands;
        this.zonings = this.inputs.zonings;
        this.odPathSets = this.inputs.odPathSets;
        this.serviceNetworks = this.inputs.serviceNetworks;
        this.routedServices = this.inputs.routedServices;
        this.outputFormatters = new TreeMap();
    }

    public void registerEligibleTrafficComponentClass(Class<? extends PlanitComponent<?>> theClazz) throws PlanItException {
        PlanitComponentFactory.registerPlanitComponentType(theClazz);
    }

    public TransportLayerNetwork<?, ?> createAndRegisterInfrastructureNetwork(String infrastructureNetworkType) throws PlanItException {
        return this.inputs.createAndRegisterInfrastructureNetwork(infrastructureNetworkType);
    }

    public Zoning createAndRegisterZoning(TransportLayerNetwork<?, ?> network) throws PlanItException {
        return this.inputs.createAndRegisterZoning(network);
    }

    public Demands createAndRegisterDemands(Zoning zoning, TransportLayerNetwork<?, ?> network) throws PlanItException {
        return this.inputs.createAndRegisterDemands(zoning, network);
    }

    public ServiceNetwork createAndRegisterServiceNetwork(MacroscopicNetwork network) throws PlanItException {
        return this.inputs.createAndRegisterServiceNetwork(network);
    }

    public RoutedServices createAndRegisterRoutedServices(ServiceNetwork serviceNetwork) throws PlanItException {
        return this.inputs.createAndRegisterRoutedServices(serviceNetwork);
    }

    public OdPathSets createAndRegisterOdPathSets(TransportLayer networkLayer, Zoning zoning, String odPathSetInputPath) throws PlanItException {
        return this.inputs.createAndRegisterOdPathSets(networkLayer, zoning, odPathSetInputPath);
    }

    public TrafficAssignmentConfigurator<? extends TrafficAssignment> createAndRegisterTrafficAssignment(String trafficAssignmentType, Demands theDemands, Zoning theZoning, TransportLayerNetwork<?, ?> theNetwork) throws PlanItException {
        TrafficAssignmentBuilder<?> taBuilder = TrafficAssignmentBuilderFactory.createBuilder(trafficAssignmentType, this.projectToken, this.inputBuilderListener, theDemands, theZoning, theNetwork);
        this.assignmentBuilders.addTrafficAssignmentBuilder(taBuilder);
        return taBuilder.getConfigurator();
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network, String fileName) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName);
    }

    public InitialLinkSegmentCost createAndRegisterInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network, String fileName, TimePeriod timePeriod) throws PlanItException {
        return this.inputs.createAndRegisterInitialLinkSegmentCost(network, fileName, timePeriod);
    }

    public OutputFormatter createAndRegisterOutputFormatter(String outputFormatterType) throws PlanItException {
        OutputFormatter outputFormatter = OutputFormatterFactory.createOutputFormatter(outputFormatterType);
        PlanItException.throwIf(outputFormatter == null, "Output writer of type " + outputFormatterType + " could not be created", new Object[0]);
        this.outputFormatters.put(outputFormatter.getId(), outputFormatter);
        return outputFormatter;
    }

    public List<InitialLinkSegmentCost> getInitialLinkSegmentCost(TransportLayerNetwork<?, ?> network) {
        return this.inputs.getInitialLinkSegmentCost(network);
    }

    public OutputFormatter getOutputFormatter(long id) {
        return this.outputFormatters.get(id);
    }

    public void executeAllTrafficAssignments() throws PlanItException {
        HashSet<Object> failedAssignments = new HashSet<Object>();
        for (TrafficAssignmentBuilder<?> tab : this.assignmentBuilders) {
            Object ta2 = null;
            try {
                ta2 = tab.build();
                LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.logActiveStateByClassName(ta2, true));
                LOGGER.info(LoggingUtils.createProjectPrefix(this.id) + LoggingUtils.createRunIdPrefix(((PlanitComponent)ta2).getId()) + "assignment created");
                ((TrafficAssignment)ta2).execute();
            }
            catch (PlanItException pe) {
                LOGGER.severe(pe.getMessage());
                if (ta2 == null) continue;
                failedAssignments.add(ta2);
            }
        }
        if (!failedAssignments.isEmpty()) {
            String failedAssignmentessage = "the following assignments failed:";
            failedAssignments.forEach(ta -> failedAssignmentessage.concat(" ").concat(String.valueOf(ta.getId())));
            throw new PlanItException(failedAssignmentessage);
        }
    }
}

