/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.sdinteraction.smoothing;

import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.utils.id.IdGroupingToken;

public class MSASmoothing
extends Smoothing {
    private static final long serialVersionUID = -3016251188673804117L;
    protected double stepSize = 1.0;
    public static final double DEFAULT_INITIAL_STEP_SIZE = 1.0;

    public MSASmoothing(IdGroupingToken groupId) {
        super(groupId);
    }

    public MSASmoothing(MSASmoothing other) {
        super(other);
        this.stepSize = other.stepSize;
    }

    @Override
    public void updateStep(int iterationIndex) {
        this.stepSize = 1.0 / (double)(iterationIndex + 1);
    }

    @Override
    public double execute(double previousValue, double proposedValue) {
        return (1.0 - this.stepSize) * previousValue + this.stepSize * proposedValue;
    }

    @Override
    public double[] execute(double[] previousValues, double[] proposedValues, int numberOfValues) {
        double[] smoothedValues = new double[numberOfValues];
        for (int i = 0; i < numberOfValues; ++i) {
            smoothedValues[i] = (1.0 - this.stepSize) * previousValues[i] + this.stepSize * proposedValues[i];
        }
        return smoothedValues;
    }

    @Override
    public MSASmoothing clone() {
        return new MSASmoothing(this);
    }

    @Override
    public void reset() {
        this.stepSize = 1.0;
    }
}

