/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.service.routed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.goplanit.service.routed.RoutedTripFrequency;
import org.goplanit.service.routed.RoutedTripImpl;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;

public class RoutedTripFrequencyImpl
extends RoutedTripImpl
implements RoutedTripFrequency {
    private static final Logger LOGGER = Logger.getLogger(RoutedTripFrequencyImpl.class.getCanonicalName());
    public final List<ServiceLegSegment> orderedLegSegments;
    public double frequencyPerHour;

    public RoutedTripFrequencyImpl(IdGroupingToken tokenId) {
        super(tokenId);
        this.orderedLegSegments = new ArrayList<ServiceLegSegment>(1);
        this.frequencyPerHour = -1.0;
    }

    public RoutedTripFrequencyImpl(RoutedTripFrequencyImpl routedTripFrequencyImpl) {
        super(routedTripFrequencyImpl);
        this.orderedLegSegments = new ArrayList<ServiceLegSegment>(routedTripFrequencyImpl.orderedLegSegments);
        this.frequencyPerHour = -1.0;
    }

    @Override
    public long recreateManagedIds(IdGroupingToken tokenId) {
        long newId = RoutedTripFrequencyImpl.generateId(tokenId);
        this.setId(newId);
        return newId;
    }

    @Override
    public RoutedTripFrequencyImpl clone() {
        return new RoutedTripFrequencyImpl(this);
    }

    @Override
    public void clearLegs() {
        this.orderedLegSegments.clear();
    }

    @Override
    public void addLegSegment(ServiceLegSegment legSegment) {
        ServiceLegSegment lastSegment;
        if (this.hasLegSegments() && !(lastSegment = this.getLastLegSegment()).getDownstreamVertex().equals(legSegment.getUpstreamVertex())) {
            LOGGER.warning("IGNORE: Unable to add leg segment that is not contiguous to current last leg segment");
            return;
        }
        this.orderedLegSegments.add(legSegment);
    }

    @Override
    public double getFrequencyPerHour() {
        return this.frequencyPerHour;
    }

    @Override
    public void setFrequencyPerHour(double frequencyPerHour) {
        this.frequencyPerHour = frequencyPerHour;
    }

    @Override
    public Iterator<ServiceLegSegment> iterator() {
        return this.orderedLegSegments.iterator();
    }

    @Override
    public int getNumberOfLegSegments() {
        return this.orderedLegSegments.size();
    }

    @Override
    public ServiceLegSegment getLegSegment(int index) {
        return this.orderedLegSegments.get(index);
    }
}

