/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.supply.fundamentaldiagram;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.component.event.PlanitComponentEvent;
import org.goplanit.component.event.PlanitComponentEventType;
import org.goplanit.component.event.PopulateFundamentalDiagramEvent;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagram;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;

public abstract class FundamentalDiagramComponent
extends PlanitComponent<FundamentalDiagramComponent>
implements Serializable {
    private static final long serialVersionUID = 5815100111048623093L;
    private static final Logger LOGGER = Logger.getLogger(FundamentalDiagramComponent.class.getCanonicalName());
    private final Map<Integer, FundamentalDiagram> uniqueFundamentalDiagrams;
    private final Map<MacroscopicLinkSegment, FundamentalDiagram> linkSegmentFundamentalDiagrams;
    private final Map<MacroscopicLinkSegmentType, FundamentalDiagram> linkSegmentTypeFundamentalDiagrams;
    public static final int RELAXED_HASH_CODE_SCALE = 6;

    private FundamentalDiagram registerUniqueFundamentalDiagram(FundamentalDiagram fundamentalDiagram) {
        int relaxedHash = fundamentalDiagram.relaxedHashCode(6);
        FundamentalDiagram usedFd = fundamentalDiagram;
        if (this.uniqueFundamentalDiagrams.containsKey(relaxedHash)) {
            usedFd = this.uniqueFundamentalDiagrams.get(relaxedHash);
        } else {
            this.uniqueFundamentalDiagrams.put(relaxedHash, usedFd);
        }
        return usedFd;
    }

    private FundamentalDiagram getOrWarning(MacroscopicLinkSegment linkSegment) {
        FundamentalDiagram foundFd = this.get(linkSegment);
        if (foundFd == null) {
            LOGGER.warning(String.format("IGNORE: Fundamental diagram absent for link segment %s to %.2f", linkSegment.getXmlId()));
        }
        return foundFd;
    }

    private FundamentalDiagram getOrWarning(MacroscopicLinkSegmentType linkSegmentType) {
        FundamentalDiagram foundFd = this.get(linkSegmentType);
        if (foundFd == null) {
            LOGGER.warning(String.format("IGNORE: Fundamental diagram absent for link segment type %s to %.2f", linkSegmentType.getXmlId()));
        }
        return foundFd;
    }

    protected abstract void initialiseDefaultFundamentalDiagramsForLayer(MacroscopicNetworkLayer var1);

    protected FundamentalDiagram register(MacroscopicLinkSegment linkSegment, FundamentalDiagram fundamentalDiagram) {
        int relaxedHash = fundamentalDiagram.relaxedHashCode(6);
        FundamentalDiagram currentFd = this.get(linkSegment);
        if (currentFd != null && currentFd.relaxedHashCode(6) == relaxedHash) {
            return currentFd;
        }
        FundamentalDiagram usedFd = this.registerUniqueFundamentalDiagram(fundamentalDiagram);
        this.linkSegmentFundamentalDiagrams.put(linkSegment, usedFd);
        return usedFd;
    }

    protected FundamentalDiagram register(MacroscopicLinkSegmentType linkSegmentType, FundamentalDiagram fundamentalDiagram) {
        int relaxedHash = fundamentalDiagram.relaxedHashCode(6);
        FundamentalDiagram currentFd = this.get(linkSegmentType);
        if (currentFd != null && currentFd.relaxedHashCode(6) == relaxedHash) {
            return currentFd;
        }
        FundamentalDiagram usedFd = this.registerUniqueFundamentalDiagram(fundamentalDiagram);
        this.linkSegmentTypeFundamentalDiagrams.put(linkSegmentType, usedFd);
        return usedFd;
    }

    public FundamentalDiagramComponent(IdGroupingToken groupId) {
        super(groupId, FundamentalDiagramComponent.class);
        this.uniqueFundamentalDiagrams = new HashMap<Integer, FundamentalDiagram>();
        this.linkSegmentFundamentalDiagrams = new HashMap<MacroscopicLinkSegment, FundamentalDiagram>();
        this.linkSegmentTypeFundamentalDiagrams = new HashMap<MacroscopicLinkSegmentType, FundamentalDiagram>();
    }

    public FundamentalDiagramComponent(FundamentalDiagramComponent other) {
        super(other);
        this.uniqueFundamentalDiagrams = new HashMap<Integer, FundamentalDiagram>(other.uniqueFundamentalDiagrams);
        this.linkSegmentFundamentalDiagrams = new HashMap<MacroscopicLinkSegment, FundamentalDiagram>(other.linkSegmentFundamentalDiagrams);
        this.linkSegmentTypeFundamentalDiagrams = new HashMap<MacroscopicLinkSegmentType, FundamentalDiagram>(other.linkSegmentTypeFundamentalDiagrams);
    }

    public FundamentalDiagram get(MacroscopicLinkSegment linkSegment) {
        FundamentalDiagram foundFd = this.linkSegmentFundamentalDiagrams.get(linkSegment);
        if (foundFd == null) {
            return this.get(linkSegment.getLinkSegmentType());
        }
        return foundFd;
    }

    public FundamentalDiagram get(MacroscopicLinkSegmentType linkSegmentType) {
        return this.linkSegmentTypeFundamentalDiagrams.get(linkSegmentType);
    }

    public void setCapacityLinkSegmentPcuHourLane(MacroscopicLinkSegment linkSegment, double capacityPcuHourLane) {
        FundamentalDiagram foundFd = this.getOrWarning(linkSegment);
        FundamentalDiagram newFd = foundFd.clone();
        newFd.setCapacityPcuHour(capacityPcuHourLane);
        this.register(linkSegment, newFd);
    }

    public void setMaximumDensityLinkSegmentPcuKmLane(MacroscopicLinkSegment linkSegment, double maxDensityPcuKmLane) {
        FundamentalDiagram foundFd = this.getOrWarning(linkSegment);
        FundamentalDiagram newFd = foundFd.clone();
        newFd.setMaximumDensityPcuKmHour(maxDensityPcuKmLane);
        this.register(linkSegment, newFd);
    }

    public void setCapacityLinkSegmentTypePcuHourLane(MacroscopicLinkSegmentType linkSegmentType, double capacityPcuHourLane) {
        FundamentalDiagram foundFd = this.getOrWarning(linkSegmentType);
        FundamentalDiagram newFd = foundFd.clone();
        newFd.setCapacityPcuHour(capacityPcuHourLane);
        this.register(linkSegmentType, newFd);
    }

    public void setMaximumDensityLinkSegmentTypePcuKmLane(MacroscopicLinkSegmentType linkSegmentType, double maxDensityPcuKmLane) {
        FundamentalDiagram foundFd = this.getOrWarning(linkSegmentType);
        FundamentalDiagram newFd = foundFd.clone();
        newFd.setMaximumDensityPcuKmHour(maxDensityPcuKmLane);
        this.register(linkSegmentType, newFd);
    }

    public FundamentalDiagram[] asLinkSegmentIndexedArray(MacroscopicLinkSegments linkSegments) {
        FundamentalDiagram[] linkSegmentFundamentalDiagrams = new FundamentalDiagram[linkSegments.size()];
        for (MacroscopicLinkSegment linkSegment : linkSegments) {
            linkSegmentFundamentalDiagrams[(int)linkSegment.getLinkSegmentId()] = this.get(linkSegment);
        }
        return linkSegmentFundamentalDiagrams;
    }

    @Override
    public void reset() {
        this.linkSegmentFundamentalDiagrams.clear();
        this.linkSegmentTypeFundamentalDiagrams.clear();
        this.uniqueFundamentalDiagrams.clear();
    }

    @Override
    public PlanitComponentEventType[] getKnownSupportedEventTypes() {
        return new PlanitComponentEventType[]{PopulateFundamentalDiagramEvent.EVENT_TYPE};
    }

    @Override
    public void onPlanitComponentEvent(PlanitComponentEvent event) throws PlanItException {
        if (!event.getType().equals(PopulateFundamentalDiagramEvent.EVENT_TYPE)) {
            return;
        }
        PopulateFundamentalDiagramEvent populateFdEvent = (PopulateFundamentalDiagramEvent)event;
        if (populateFdEvent.getFundamentalDiagramToPopulate() != this) {
            return;
        }
        this.initialiseDefaultFundamentalDiagramsForLayer(populateFdEvent.getParentNetworkLayer());
    }

    @Override
    public abstract FundamentalDiagramComponent clone();
}

