/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventListenerPriority;
import org.goplanit.utils.event.EventType;

public abstract class EventProducerImpl {
    private static final Logger LOGGER = Logger.getLogger(EventProducerImpl.class.getCanonicalName());
    protected Map<EventType, Map<EventListenerPriority, List<EventListener>>> listeners = new HashMap<EventType, Map<EventListenerPriority, List<EventListener>>>();

    protected final synchronized void addListener(EventListener listener, EventListenerPriority priority) {
        if (!listener.hasKnownSupportedEventTypes()) {
            LOGGER.severe("IGNORED: unable to identify listener's supported event types, consider registering with explicit event types, or provide supported types by implementing hasKnownSupportedEventTypes() on listener");
        }
        if (listener.getKnownSupportedEventTypes().length > 0) {
            this.addListener(listener, priority, listener.getKnownSupportedEventTypes());
        }
    }

    protected final synchronized void addListener(EventListener listener, EventListenerPriority priority, EventType ... eventTypes) {
        for (int index = 0; index < eventTypes.length; ++index) {
            EventType type = eventTypes[index];
            this.listeners.putIfAbsent(type, new TreeMap());
            Map<EventListenerPriority, List<EventListener>> listenersByEventType = this.listeners.get(type);
            listenersByEventType.putIfAbsent(priority, new ArrayList());
            listenersByEventType.get((Object)priority).add(listener);
        }
    }

    protected final synchronized void addListener(EventListener listener, EventType ... eventTypes) {
        this.addListener(listener, EventListenerPriority.LOW, eventTypes);
    }

    protected final synchronized void addListener(EventListener listener) {
        if (!listener.hasKnownSupportedEventTypes()) {
            LOGGER.severe("IGNORED: unable to identify listener's supported event types, consider registering with explicit event types, or provide supported types by implementing hasKnownSupportedEventTypes() on listener");
        }
        this.addListener(listener, listener.getKnownSupportedEventTypes());
    }

    protected final synchronized boolean removeListener(EventListener listener, EventType eventType) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        if (eventType == null) {
            throw new IllegalArgumentException("event type cannot be null");
        }
        if (!this.listeners.containsKey(eventType)) {
            return false;
        }
        boolean result = false;
        Map<EventListenerPriority, List<EventListener>> listenersByEventType = this.listeners.get(eventType);
        for (EventListenerPriority priority : listenersByEventType.keySet()) {
            Iterator<EventListener> i = listenersByEventType.get((Object)priority).iterator();
            while (i.hasNext()) {
                if (!listener.equals(i.next())) continue;
                i.remove();
                result = true;
                break;
            }
            if (!listenersByEventType.get((Object)priority).isEmpty()) continue;
            listenersByEventType.remove((Object)priority);
        }
        if (this.listeners.get(eventType).isEmpty()) {
            this.listeners.remove(eventType);
        }
        return result;
    }

    protected final synchronized boolean removeListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        boolean result = false;
        ArrayList<EventType> registeredEventTypes = new ArrayList<EventType>(this.listeners.keySet());
        for (EventType eventType : registeredEventTypes) {
            result = this.removeListener(listener, eventType) || result;
        }
        return result;
    }

    protected abstract void fireEvent(EventListener var1, Event var2);

    protected synchronized void fireEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (event.getType() == null) {
            throw new IllegalArgumentException("event type cannot be null");
        }
        if (this.listeners.containsKey(event.getType())) {
            Map<EventListenerPriority, List<EventListener>> listenersForEventType = this.listeners.get(event.getType());
            TreeSet<EventListenerPriority> availablePriorities = new TreeSet<EventListenerPriority>(listenersForEventType.keySet());
            for (EventListenerPriority priority : availablePriorities) {
                ArrayList listenersForEventAndPriority = new ArrayList(listenersForEventType.get((Object)priority));
                for (EventListener listener : listenersForEventAndPriority) {
                    this.fireEvent(listener, event);
                }
            }
        }
    }

    protected EventProducerImpl() {
    }

    public synchronized void removeAllListeners() {
        this.listeners = null;
        this.listeners = new HashMap<EventType, Map<EventListenerPriority, List<EventListener>>>();
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public boolean hasListener(EventType eventType) {
        return this.listeners.containsKey(eventType);
    }

    public synchronized int numberOfListeners(EventType eventType) {
        if (this.listeners.containsKey(eventType)) {
            return this.listeners.get(eventType).size();
        }
        return 0;
    }

    public synchronized Set<EventType> getEventTypesWithListeners() {
        return Collections.unmodifiableSet(this.listeners.keySet());
    }
}

