/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitCrsUtils {
    private static final Logger LOGGER = Logger.getLogger(PlanitCrsUtils.class.getCanonicalName());

    protected static void silenceHsqlLogging() {
        Logger.getLogger("org.hsqldb").setLevel(Level.WARNING);
        System.setProperty("hsqldb.reconfig_logging", "false");
    }

    public static CoordinateReferenceSystem createCoordinateReferenceSystem(String code) {
        PlanitCrsUtils.silenceHsqlLogging();
        CoordinateReferenceSystem crs = null;
        if (code != null) {
            try {
                crs = CRS.decode(code);
            }
            catch (Exception e1) {
                try {
                    crs = CRS.decode(code, true);
                }
                catch (Exception e2) {
                    LOGGER.warning(String.format("unable to find coordinate reference system for %s", code));
                }
            }
        }
        return crs;
    }
}

