/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.geo;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsIntersectEdgeVisitor;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.linearref.LinearLocation;

public class PlanitGraphGeoUtils {
    static final Logger LOGGER = Logger.getLogger(PlanitGraphGeoUtils.class.getCanonicalName());

    protected static <T> Pair<T, Double> findMinimumValuePair(Map<? extends T, Double> valueMap) {
        Map.Entry<T, Double> minEntry = null;
        for (Map.Entry<T, Double> entry : valueMap.entrySet()) {
            if (minEntry != null && !((Double)minEntry.getValue() + 1.0E-6 > entry.getValue())) continue;
            minEntry = entry;
        }
        if (minEntry == null) {
            return null;
        }
        return Pair.of(minEntry.getKey(), (Double)minEntry.getValue());
    }

    protected static <T> void removePlanitEntitiesBeyondValue(Map<? extends T, Double> entitiesToFilter, Double maxValue) {
        Iterator<Map.Entry<T, Double>> iterator = entitiesToFilter.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Double> entry = iterator.next();
            if (!(entry.getValue() - 1.0E-6 > maxValue)) continue;
            iterator.remove();
        }
    }

    protected static <T> Double findPlanitEntityDistance(Point referencePoint, T planitEntity, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        if (planitEntity instanceof Zone) {
            Coordinate closestCoordinate = geoUtils.getClosestProjectedCoordinateOnGeometry(referencePoint, ((Zone)planitEntity).getGeometry());
            return geoUtils.getDistanceInMetres(referencePoint.getCoordinate(), closestCoordinate);
        }
        if (planitEntity instanceof Edge) {
            return geoUtils.getClosestProjectedDistanceInMetersToLineString(referencePoint, ((Edge)planitEntity).getGeometry());
        }
        LOGGER.warning(String.format("Unsupported planit entity to compute closest distance to %s", planitEntity.getClass().getCanonicalName()));
        return null;
    }

    protected static <T> Map<T, Double> findPlanitEntitiesDistance(Point referencePoint, Collection<? extends T> planitEntities, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        TreeMap<T, Double> distanceMap = new TreeMap<T, Double>();
        for (T entity : planitEntities) {
            distanceMap.put(entity, PlanitGraphGeoUtils.findPlanitEntityDistance(referencePoint, entity, geoUtils));
        }
        return distanceMap;
    }

    protected static <T> Map<T, Double> findPlanitEntitiesDistance(LineString lineString, Collection<? extends T> planitEntities, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<T, Double> distanceMap = null;
        int numCoordinates = lineString.getCoordinates().length;
        for (int index = 0; index < numCoordinates; ++index) {
            Coordinate coordinate = lineString.getCoordinateN(index);
            Map<T, Double> coordinateDistanceMap = PlanitGraphGeoUtils.findPlanitEntitiesDistance(PlanitJtsUtils.createPoint(coordinate), planitEntities, geoUtils);
            if (distanceMap == null) {
                distanceMap = coordinateDistanceMap;
                continue;
            }
            for (Map.Entry<T, Double> entry : coordinateDistanceMap.entrySet()) {
                if (distanceMap.containsKey(entry.getKey()) && !(distanceMap.get(entry.getKey()) > entry.getValue())) continue;
                distanceMap.put(entry.getKey(), entry.getValue());
            }
        }
        return distanceMap;
    }

    protected static <T> Set<? extends T> findPlanitEntitiesWithinDistance(LineString lineString, Collection<? extends T> planitEntities, Double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(lineString, planitEntities, geoUtils);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, maxDistanceMeters);
        return result.keySet();
    }

    protected static <T> Set<? extends T> findPlanitEntitiesWithinDistance(Point referencePoint, Collection<? extends T> planitEntities, Double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(referencePoint, planitEntities, geoUtils);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, maxDistanceMeters);
        return result.keySet();
    }

    protected static <T> Pair<T, Double> findPlanitEntityClosest(Point referencePoint, Collection<? extends T> planitEntities, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<? extends T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(referencePoint, planitEntities, geoUtils);
        return PlanitGraphGeoUtils.findMinimumValuePair(result);
    }

    protected static <T> Pair<T, Double> findPlanitEntityClosest(LineString lineString, Collection<? extends T> planitEntities, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<? extends T, Double> result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(lineString, planitEntities, geoUtils);
        return PlanitGraphGeoUtils.findMinimumValuePair(result);
    }

    public static Edge findEdgeClosest(Geometry geometry, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosest(geometry, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosest(Geometry geometry, Collection<? extends Edge> edges, double marginToClosestMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        if (geometry == null || edges == null || geoUtils == null) {
            return null;
        }
        if (edges.size() == 1) {
            return Pair.of(edges.iterator().next(), null);
        }
        if (geometry instanceof Point) {
            return PlanitGraphGeoUtils.findEdgesClosestToPoint((Point)geometry, edges, marginToClosestMeters, geoUtils);
        }
        if (geometry instanceof LineString) {
            return PlanitGraphGeoUtils.findEdgesClosestToLineString((LineString)geometry, edges, marginToClosestMeters, geoUtils);
        }
        return null;
    }

    public static <T extends Edge> Quadtree createSpatiallyIndexedPlanitEdges(Collection<? extends GraphEntities<T>> edgesCollection) {
        Quadtree spatiallyIndexedEdges = new Quadtree();
        for (GraphEntities<Edge> graphEntities : edgesCollection) {
            graphEntities.forEach(edge -> spatiallyIndexedEdges.insert(edge.getGeometry().getEnvelope().getEnvelopeInternal(), edge));
        }
        return spatiallyIndexedEdges;
    }

    public static Edge findEdgeClosestToLineString(LineString lineString, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosestToLineString(lineString, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Edge findEdgeClosestToPoint(Point point, Collection<? extends Edge> edges, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<? extends Edge, Set<? extends Edge>> result = PlanitGraphGeoUtils.findEdgesClosestToPoint(point, edges, 0.0, geoUtils);
        return result != null ? result.first() : null;
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToLineString(LineString lineString, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return PlanitGraphGeoUtils.findEdgesClosestToGeometry(lineString, edges, bufferDistanceMeters, geoUtils);
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToPoint(Point point, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return PlanitGraphGeoUtils.findEdgesClosestToGeometry(point, edges, bufferDistanceMeters, geoUtils);
    }

    public static Pair<? extends Edge, Set<? extends Edge>> findEdgesClosestToGeometry(Geometry geometry, Collection<? extends Edge> edges, double bufferDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Map<? extends Edge, Double> result = null;
        if (geometry instanceof Point) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance((Point)geometry, edges, geoUtils);
        } else if (geometry instanceof LineString) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance((LineString)geometry, edges, geoUtils);
        } else if (geometry instanceof Polygon) {
            result = PlanitGraphGeoUtils.findPlanitEntitiesDistance(((Polygon)geometry).getExteriorRing(), edges, geoUtils);
        } else {
            throw new PlanItException("Unsupported geometry encountered when finding edges closest to geometry");
        }
        Pair<? extends Edge, Double> minResult = PlanitGraphGeoUtils.findMinimumValuePair(result);
        PlanitGraphGeoUtils.removePlanitEntitiesBeyondValue(result, minResult.second() + bufferDistanceMeters);
        result.remove(minResult.first());
        return Pair.of(minResult.first(), new TreeSet<Edge>(result.keySet()));
    }

    public static <T extends Edge> Collection<T> findEdgesSpatially(Envelope searchBoundingBox, Quadtree spatiallyIndexedEdgeTree) {
        PlanitJtsIntersectEdgeVisitor edgevisitor = new PlanitJtsIntersectEdgeVisitor(PlanitJtsUtils.create2DPolygon(searchBoundingBox), new HashSet());
        spatiallyIndexedEdgeTree.query(searchBoundingBox, edgevisitor);
        return edgevisitor.getResult();
    }

    public static <T extends EdgeSegment> LineSegment extractClosestLineSegmentTo(Geometry referenceGeometry, T edgeSegment, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        LineString linkSegmentGeometry = edgeSegment.getParentEdge().getGeometry();
        if (linkSegmentGeometry == null) {
            throw new PlanItException("Geometry not available on edge segment %d (external id %s), unable to determine closest line segment to reference geometry, this shouldn't happen", edgeSegment.getId(), edgeSegment.getExternalId());
        }
        LinearLocation linearLocation = geoUtils.getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(referenceGeometry, linkSegmentGeometry);
        boolean reverseLinearLocationGeometry = edgeSegment.isDirectionAb() != edgeSegment.getParentEdge().isGeometryInAbDirection();
        LineSegment lineSegment = linearLocation.getSegment(edgeSegment.getParentEdge().getGeometry());
        if (reverseLinearLocationGeometry) {
            lineSegment.reverse();
        }
        return lineSegment;
    }

    public static boolean isVertexNearBoundingBox(Vertex node, Envelope boundingBox, double maxDistanceMeters, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return geoUtils.isGeometryNearBoundingBox(node.getPosition(), boundingBox, maxDistanceMeters);
    }
}

