/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.io.Serializable;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;

public interface EdgeSegment
extends Serializable,
GraphEntity {
    public static final Class<EdgeSegment> EDGE_SEGMENT_ID_CLASS = EdgeSegment.class;

    public boolean remove(DirectedVertex var1);

    public void setUpstreamVertex(DirectedVertex var1);

    public DirectedVertex getUpstreamVertex();

    public DirectedVertex getDownstreamVertex();

    public void setDownstreamVertex(DirectedVertex var1);

    public DirectedEdge getParentEdge();

    public void removeParentEdge();

    public boolean isDirectionAb();

    public boolean validate();

    @Override
    public EdgeSegment clone();

    public void setParent(DirectedEdge var1);

    default public Class<EdgeSegment> getIdClass() {
        return EDGE_SEGMENT_ID_CLASS;
    }

    default public boolean replace(DirectedVertex vertexToReplace, DirectedVertex vertexToReplaceWith) {
        boolean vertexReplaced = false;
        if (vertexToReplaceWith != null) {
            if (this.getUpstreamVertex() != null && vertexToReplace.getId() == this.getUpstreamVertex().getId()) {
                vertexReplaced = this.remove(vertexToReplace);
                this.setUpstreamVertex(vertexToReplaceWith);
            } else if (this.getDownstreamVertex() != null && vertexToReplace.getId() == this.getDownstreamVertex().getId()) {
                vertexReplaced = this.remove(vertexToReplace);
                this.setDownstreamVertex(vertexToReplaceWith);
            }
        }
        return vertexReplaced;
    }

    default public boolean hasParentName() {
        if (this.getParentEdge() != null) {
            return this.getParentEdge().hasName();
        }
        return false;
    }

    default public String getParentName() {
        if (this.getParentEdge() != null) {
            return this.getParentEdge().getName();
        }
        return null;
    }
}

