/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.goplanit.utils.graph.GraphEntity;
import org.goplanit.utils.graph.GraphEntityFactory;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.wrapper.LongMapWrapper;

public interface GraphEntities<E extends GraphEntity>
extends LongMapWrapper<E>,
Cloneable {
    public GraphEntityFactory<E> getFactory();

    public GraphEntities<E> clone();

    default public E getByXmlId(String xmlId) {
        return (E)this.findFirst(entity -> xmlId.equals(entity.getXmlId()));
    }

    default public Collection<E> getByExternalId(String externalId) {
        ArrayList<GraphEntity> matches = new ArrayList<GraphEntity>(1);
        for (GraphEntity entity : this) {
            if (!entity.getExternalId().equals(externalId)) continue;
            matches.add(entity);
        }
        return matches;
    }

    default public <T extends IdAble> void forEachMatchingIdIn(Collection<T> values, Consumer<T> consumer) {
        values.forEach(v -> {
            if (this.containsKey(v.getId())) {
                consumer.accept(v);
            }
        });
    }
}

