/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.directed;

import java.util.Set;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.Vertex;

public interface DirectedVertex
extends Vertex {
    public boolean addEdgeSegment(EdgeSegment var1);

    default public boolean removeEdgeSegment(EdgeSegment edgeSegment) {
        return this.removeEntryEdgeSegment(edgeSegment) || this.removeExitEdgeSegment(edgeSegment);
    }

    public boolean removeEntryEdgeSegment(EdgeSegment var1);

    public boolean removeExitEdgeSegment(EdgeSegment var1);

    public Set<EdgeSegment> getEntryEdgeSegments();

    public Set<EdgeSegment> getExitEdgeSegments();

    default public boolean replace(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith, boolean forceInsert) {
        if (this.removeEdgeSegment(edgeSegmentToReplace) || forceInsert) {
            return this.addEdgeSegment(edgeSegmentToReplaceWith);
        }
        return false;
    }

    default public boolean replaceExitSegment(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith, boolean forceInsert) {
        if (this.removeExitEdgeSegment(edgeSegmentToReplace) || forceInsert) {
            return this.addEdgeSegment(edgeSegmentToReplaceWith);
        }
        return false;
    }

    default public boolean replaceEntrySegment(EdgeSegment edgeSegmentToReplace, EdgeSegment edgeSegmentToReplaceWith, boolean forceInsert) {
        if (this.removeEntryEdgeSegment(edgeSegmentToReplace) || forceInsert) {
            return this.addEdgeSegment(edgeSegmentToReplaceWith);
        }
        return false;
    }

    default public EdgeSegment getEdgeSegment(DirectedVertex otherVertex) {
        for (EdgeSegment edgeSegment : this.getExitEdgeSegments()) {
            if (!edgeSegment.getDownstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        for (EdgeSegment edgeSegment : this.getEntryEdgeSegments()) {
            if (!edgeSegment.getUpstreamVertex().equals(otherVertex)) continue;
            return edgeSegment;
        }
        return null;
    }

    default public boolean hasExitEdgeSegments() {
        return this.getExitEdgeSegments() != null && !this.getExitEdgeSegments().isEmpty();
    }

    default public boolean hasEntryEdgeSegments() {
        return this.getEntryEdgeSegments() != null && !this.getEntryEdgeSegments().isEmpty();
    }

    default public int sizeOfEntryEdgeSegments() {
        return this.getEntryEdgeSegments().size();
    }

    default public int sizeOfExitEdgeSegments() {
        return this.getExitEdgeSegments().size();
    }
}

