/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.graph.modifier;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.modifier.TopologicalModifier;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventProducer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface GraphModifier<V extends Vertex, E extends Edge>
extends GraphModifierEventProducer,
TopologicalModifier {
    public void removeDanglingSubGraphs(Integer var1, Integer var2, boolean var3) throws PlanItException;

    public void removeSubGraph(Set<? extends V> var1);

    public void removeSubGraphOf(V var1) throws PlanItException;

    public <Ex extends E> Map<Long, Set<Ex>> breakEdgesAt(List<Ex> var1, V var2, CoordinateReferenceSystem var3) throws PlanItException;

    public <Ex extends E> Ex breakEdgeAt(V var1, Ex var2, PlanitJtsCrsUtils var3) throws PlanItException;

    public void recreateManagedEntitiesIds();

    default public void removeDanglingSubGraphs() throws PlanItException {
        boolean alwaysKeepLargest = true;
        this.removeDanglingSubGraphs(Integer.MAX_VALUE, Integer.MAX_VALUE, alwaysKeepLargest);
    }

    default public <Ex extends E> Map<Long, Set<Ex>> breakEdgesAt(List<Ex> edgesToBreak, V vertexToBreakAt) throws PlanItException {
        return this.breakEdgesAt(edgesToBreak, vertexToBreakAt, PlanitJtsCrsUtils.CARTESIANCRS);
    }

    public void reset();
}

