/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.misc;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.UrlUtils;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getCanonicalName());
    public static final String DOT = ".";
    public static final String ZIP = "zip";

    public static String getExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(DOT) != -1 && fileName.lastIndexOf(DOT) != 0) {
            return fileName.substring(fileName.lastIndexOf(DOT) + 1);
        }
        return "";
    }

    public static File[] getFilesWithExtensionFromDir(String pathToDir, final String fileExtension) throws PlanItException {
        PlanItException.throwIfNull(pathToDir, String.format("path directory is null when collecting files", new Object[0]));
        PlanItException.throwIfNull(fileExtension, String.format("file extension to use is null when collecting files from directory", new Object[0]));
        File directoryPath = new File(pathToDir);
        PlanItException.throwIf(!directoryPath.isDirectory(), String.format("%s is not a valid directory", directoryPath), new Object[0]);
        FilenameFilter fileExtensionFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lowercaseName = name.toLowerCase();
                return lowercaseName.endsWith(fileExtension);
            }
        };
        return directoryPath.listFiles(fileExtensionFilter);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        if (fileName != null && fileName.contains(DOT)) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    public static void callForEachFileIn(String pathToDir, Consumer<File> callBack) {
        if (pathToDir == null) {
            return;
        }
        if (callBack == null) {
            LOGGER.warning(String.format("No callback provided for any file in %s", pathToDir));
        }
        File[] filesInDir = new File(pathToDir).listFiles();
        for (int index = 0; index < filesInDir.length; ++index) {
            callBack.accept(filesInDir[index]);
        }
    }

    public static File create(URL url) {
        if (UrlUtils.isLocal(url)) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                LOGGER.warning(String.format("Unable to convert URL %s to file", url.toString()));
            }
        }
        return null;
    }

    public static boolean deleteDirectory(File directoryToDelete) {
        if (!directoryToDelete.isDirectory()) {
            return false;
        }
        File[] filesInDir = directoryToDelete.listFiles();
        if (filesInDir != null) {
            for (File file : filesInDir) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directoryToDelete.delete();
    }
}

