/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.network.layer.macroscopic;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.AccessGroupProperties;

public interface MacroscopicLinkSegmentType
extends Cloneable,
ExternalIdAble,
ManagedId {
    public static final Class<MacroscopicLinkSegmentType> MACROSCOPIC_LINK_SEGMENT_TYPE_ID_CLASS = MacroscopicLinkSegmentType.class;
    public static final String DEFAULT_XML_ID = "1";

    @Override
    public MacroscopicLinkSegmentType clone();

    public String getName();

    public void setName(String var1);

    public Double getExplicitCapacityPerLane();

    default public double getExplicitCapacityPerLaneOrDefault() {
        return this.isExplicitCapacityPerLaneSet() ? this.getExplicitCapacityPerLane() : 1800.0;
    }

    default public boolean isExplicitCapacityPerLaneSet() {
        return this.getExplicitCapacityPerLane() != null;
    }

    public Double getExplicitMaximumDensityPerLane();

    default public double getExplicitMaximumDensityPerLaneOrDefault() {
        return this.isExplicitMaximumDensityPerLaneSet() ? this.getExplicitMaximumDensityPerLane() : 180.0;
    }

    default public boolean isExplicitMaximumDensityPerLaneSet() {
        return this.getExplicitMaximumDensityPerLane() != null;
    }

    public void setAccessGroupProperties(Collection<AccessGroupProperties> var1);

    public void setAccessGroupProperties(AccessGroupProperties var1);

    public void addAccessGroupProperties(AccessGroupProperties var1);

    public boolean removeModeAccess(Mode var1);

    public AccessGroupProperties getAccessProperties(Mode var1);

    public boolean isModeAllowed(Mode var1);

    public Set<Mode> getAllowedModes();

    default public Set<Mode> getDisallowedModesFrom(Collection<Mode> modes) {
        return modes.stream().filter(mode -> !this.isModeAllowed((Mode)mode)).collect(Collectors.toSet());
    }

    default public Set<Mode> getAllowedModesFrom(Collection<Mode> modes) {
        return modes.stream().filter(mode -> this.isModeAllowed((Mode)mode)).collect(Collectors.toSet());
    }

    default public Set<Mode> getAllowedModesNotIn(Collection<Mode> modes) {
        return this.getAllowedModes().stream().filter(mode -> !modes.contains(mode)).collect(Collectors.toSet());
    }

    default public boolean hasAllowedModes() {
        return this.getAllowedModes() != null && !this.getAllowedModes().isEmpty();
    }

    public AccessGroupProperties findEqualAccessPropertiesForAnyMode(AccessGroupProperties var1);

    default public Double getMaximumSpeedKmH(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return 0.0;
        }
        return this.getAccessProperties(mode).getMaximumSpeedOrDefaultKmH(mode.getMaximumSpeedKmH());
    }

    default public Double getCriticalSpeedKmH(Mode mode) {
        if (!this.isModeAllowed(mode)) {
            return null;
        }
        return this.getAccessProperties(mode).getCriticalSpeedOrDefaultKmH(mode.getMaximumSpeedKmH());
    }

    default public Class<? extends MacroscopicLinkSegmentType> getIdClass() {
        return MACROSCOPIC_LINK_SEGMENT_TYPE_ID_CLASS;
    }

    default public void removeModeAccess(Set<Mode> toBeRemovedModes) {
        toBeRemovedModes.forEach(mode -> this.removeModeAccess((Mode)mode));
    }
}

