/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.od;

import java.util.logging.Logger;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.od.OdMatrixImpl;
import org.goplanit.utils.od.OdMatrixIterator;
import org.goplanit.utils.zoning.OdZones;
import org.goplanit.utils.zoning.Zone;

public abstract class OdNonPrimitiveMatrix<T>
extends OdMatrixImpl<T, T[][]> {
    private static final Logger LOGGER = Logger.getLogger(OdNonPrimitiveMatrix.class.getCanonicalName());

    public OdNonPrimitiveMatrix(Class<? extends IdAble> idTokenClass, IdGroupingToken idToken, OdZones zones, T[][] matrixContents) {
        super(idTokenClass, idToken, zones, matrixContents);
    }

    public OdNonPrimitiveMatrix(OdNonPrimitiveMatrix<T> other) {
        super(other);
    }

    @Override
    public void setValue(Zone origin, Zone destination, T value) {
        ((Object[][])this.matrixContents)[(int)origin.getId()][(int)destination.getId()] = value;
    }

    @Override
    public T getValue(Zone origin, Zone destination) {
        return (T)((Object[][])this.matrixContents)[(int)origin.getId()][(int)destination.getId()];
    }

    @Override
    public T getValue(long originId, long destinationId) {
        return (T)((Object[][])this.matrixContents)[(int)originId][(int)destinationId];
    }

    @Override
    public abstract OdMatrixIterator<T, T[][]> iterator();
}

