/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.path;

import java.util.function.Function;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.path.DirectedPath;

public class PathUtils {
    public static String getNodePathString(DirectedPath path, Function<Vertex, Object> idMapper) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : path) {
            DirectedVertex vertex = edgeSegment.getUpstreamVertex();
            if (!(vertex instanceof Node)) continue;
            Node node = (Node)vertex;
            builder.append(idMapper.apply(node));
            if (!(edgeSegment.getDownstreamVertex() instanceof Node)) continue;
            builder.append(",");
        }
        builder.append("]");
        return new String(builder);
    }

    public static String getEdgeSegmentPathString(DirectedPath path, Function<EdgeSegment, Object> idGetter) {
        StringBuilder builder = new StringBuilder("[");
        for (EdgeSegment edgeSegment : path) {
            builder.append(idGetter.apply(edgeSegment));
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return new String(builder);
    }
}

