/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.reflection;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.utils.exceptions.PlanItException;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getCanonicalName());

    public static Class<?>[] getParameterTypes(Object[] parameters) {
        List parameterTypes = Arrays.stream(parameters).map(Object::getClass).collect(Collectors.toList());
        return (Class[])parameterTypes.toArray(Class[]::new);
    }

    public static <T> T createTypedInstance(String className, Object ... constructorParameters) throws PlanItException {
        return (T)ReflectionUtils.createInstance(className, constructorParameters);
    }

    public static Object createInstance(String className, Object ... constructorParameters) throws PlanItException {
        Object createdInstance = null;
        if (constructorParameters != null) {
            Constructor<?> constructor = null;
            try {
                Class<?>[] parameterTypes = ReflectionUtils.getParameterTypes(constructorParameters);
                constructor = Class.forName(className).getConstructor(parameterTypes);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                LOGGER.severe(String.format("Unable to find constructor for given arguments when constructing instance of %s \n likely constructor either requires different number of arguments or it requires super types \nwhereas provided arguments are implementations of this type \nand reflection is not able to infer this as a valid call, see also https://github.com/TrafficPLANit/PLANitUtils/issues/7", className));
                e.printStackTrace();
                LOGGER.severe(e.getMessage());
                throw new PlanItException("Unable to find appropriate constructor for type: " + className, e);
            }
            try {
                createdInstance = constructor.newInstance(constructorParameters);
            }
            catch (Exception e) {
                throw new PlanItException("Unable to create instance of type: " + className, e);
            }
        }
        try {
            createdInstance = Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PlanItException("Unable to create instance of type via default constructor: " + className, e);
        }
        return createdInstance;
    }
}

