/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.unit;

import java.util.logging.Logger;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.unit.SimpleUnit;
import org.goplanit.utils.unit.Unit;
import org.goplanit.utils.unit.UnitGroup;
import org.goplanit.utils.unit.UnitType;

public class TimeUnit
extends SimpleUnit {
    private static final Logger LOGGER = Logger.getLogger(TimeUnit.class.getCanonicalName());
    public static final double HOUR_2_MINUTE = 60.0;
    public static final double MINUTE_2_HOUR = 0.016666666666666666;
    public static final double MINUTE_2_SECOND = 60.0;
    public static final double SECOND_2_MINUTE = 0.016666666666666666;
    public static final double HOUR_2_SECOND = 3600.0;
    public static final double SECOND_2_HOUR = 2.777777777777778E-4;

    protected TimeUnit(UnitType unitType) {
        super(unitType);
        if (!unitType.group.equals((Object)UnitGroup.TIME)) {
            LOGGER.warning(String.format("Invalid unit type %s for time based unit", unitType.name));
            unitType = UnitType.NONE;
        }
    }

    public static double convertSecondTo(UnitType to, double value) throws PlanItException {
        if (to == null) {
            throw new PlanItException(String.format("to unit null, conversion infeasible", new Object[0]));
        }
        switch (to) {
            case HOUR: {
                return value * 2.777777777777778E-4;
            }
            case MINUTE: {
                return value * 0.016666666666666666;
            }
            case SECOND: {
                return value;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.SECOND, to}));
    }

    public static double convertMinuteTo(UnitType to, double value) throws PlanItException {
        if (to == null) {
            throw new PlanItException(String.format("to unit null, conversion infeasible", new Object[0]));
        }
        switch (to) {
            case MINUTE: {
                return value;
            }
            case HOUR: {
                return value * 0.016666666666666666;
            }
            case SECOND: {
                return value * 60.0;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.MINUTE, to}));
    }

    public static double convertHourTo(UnitType to, double value) throws PlanItException {
        if (to == null) {
            throw new PlanItException(String.format("to unit null, conversion infeasible", new Object[0]));
        }
        switch (to) {
            case HOUR: {
                return value;
            }
            case MINUTE: {
                return value * 60.0;
            }
            case SECOND: {
                return value * 3600.0;
            }
        }
        throw new PlanItException(String.format("conversion illegal or not supported yet from %s --> %s", new Object[]{UnitType.HOUR, to}));
    }

    @Override
    public double convertTo(Unit to, double value) throws PlanItException {
        TimeUnit toUnit = (TimeUnit)to;
        switch (this.unitType) {
            case MINUTE: {
                return TimeUnit.convertMinuteTo(toUnit.unitType, value);
            }
            case SECOND: {
                return TimeUnit.convertSecondTo(toUnit.unitType, value);
            }
            case HOUR: {
                return TimeUnit.convertHourTo(toUnit.unitType, value);
            }
        }
        throw new PlanItException("Unsupported time unit encountered on from Unit");
    }
}

