/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.utils.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.ManagedId;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.zoning.Centroid;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public interface Zone
extends ExternalIdAble,
ManagedId {
    public static final Logger LOGGER = Logger.getLogger(Zone.class.getCanonicalName());
    public static final Class<Zone> ZONE_ID_CLASS = Zone.class;

    public void addInputProperty(String var1, Object var2);

    public Object getInputProperty(String var1);

    public Centroid getCentroid();

    public void setGeometry(Geometry var1);

    public Geometry getGeometry();

    public void setName(String var1);

    public String getName();

    @Override
    public Zone clone();

    default public Class<Zone> getIdClass() {
        return ZONE_ID_CLASS;
    }

    default public boolean hasGeometry() {
        return this.getGeometry() != null;
    }

    default public boolean hasCentroid() {
        return this.getCentroid() != null;
    }

    default public boolean hasName() {
        return !StringUtils.isNullOrBlank(this.getName());
    }

    default public boolean hasInputProperty(String key) {
        return this.getInputProperty(key) != null;
    }

    default public Envelope getEnvelope() {
        if (this.hasGeometry() && !this.getGeometry().isEmpty()) {
            return this.getGeometry().getEnvelope().getEnvelopeInternal();
        }
        if (this.hasCentroid() && this.getCentroid().hasPosition()) {
            return this.getCentroid().getPosition().getEnvelopeInternal();
        }
        LOGGER.warning(String.format("zone (id:%s) has no valid geometry to collect envelope (bounding box) for", this.getXmlId()));
        return null;
    }
}

