/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.Connectoids;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.zoning.ConnectoidImpl;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;

public abstract class ConnectoidsImpl<T extends Connectoid>
extends ManagedIdEntitiesImpl<T>
implements Connectoids<T> {
    private static final Logger LOGGER = Logger.getLogger(ConnectoidsImpl.class.getCanonicalName());

    protected void updateConnectoidAccessZoneIdReferences() {
        for (Connectoid connectoid : this) {
            if (!(connectoid instanceof ConnectoidImpl)) {
                LOGGER.severe("recreation of transfer zone ids utilises unsupported implementation of connectoids interface when attempting to update access zone references");
            }
            ((ConnectoidImpl)connectoid).recreateAccessZoneIdMapping();
        }
    }

    public ConnectoidsImpl(IdGroupingToken groupId) {
        super(IdAble::getId, Connectoid.CONNECTOID_ID_CLASS);
    }

    public ConnectoidsImpl(ConnectoidsImpl<T> connectoidsImpl) {
        super(connectoidsImpl);
    }

    @Override
    public abstract ConnectoidsImpl<T> clone();

    @Override
    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{ModifiedZoneIdsEvent.EVENT_TYPE};
    }

    @Override
    public void onZoningModifierEvent(ZoningModificationEvent event) {
        if (event.getType().equals(ModifiedZoneIdsEvent.EVENT_TYPE)) {
            this.updateConnectoidAccessZoneIdReferences();
        }
    }
}

