/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.zoning;

import java.util.logging.Logger;
import org.goplanit.utils.event.EventType;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntitiesImpl;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneGroupFactory;
import org.goplanit.utils.zoning.TransferZoneGroups;
import org.goplanit.utils.zoning.modifier.event.ZoningModificationEvent;
import org.goplanit.zoning.ConnectoidsImpl;
import org.goplanit.zoning.TransferZoneGroupFactoryImpl;
import org.goplanit.zoning.TransferZoneGroupImpl;
import org.goplanit.zoning.modifier.event.ModifiedZoneIdsEvent;

public class TransferZoneGroupsImpl
extends ManagedIdEntitiesImpl<TransferZoneGroup>
implements TransferZoneGroups {
    private final TransferZoneGroupFactory transferZoneGroupFactory;
    private static final Logger LOGGER = Logger.getLogger(ConnectoidsImpl.class.getCanonicalName());

    protected void recreateTransferZoneGroupsZoneIdMapping() {
        for (TransferZoneGroup group : this) {
            if (!(group instanceof TransferZoneGroupImpl)) {
                LOGGER.severe("recreation of transfer zone ids utilises unsupported implementation of TransferZoneGroup interface when attempting to update references");
            }
            ((TransferZoneGroupImpl)group).recreateTransferZoneIdMapping();
        }
    }

    public TransferZoneGroupsImpl(IdGroupingToken groupId) {
        super(IdAble::getId, TransferZoneGroup.TRANSFER_ZONE_GROUP_ID_CLASS);
        this.transferZoneGroupFactory = new TransferZoneGroupFactoryImpl(groupId, this);
    }

    public TransferZoneGroupsImpl(IdGroupingToken groupId, TransferZoneGroupFactory transferZoneGroupFactory) {
        super(IdAble::getId, TransferZoneGroup.TRANSFER_ZONE_GROUP_ID_CLASS);
        this.transferZoneGroupFactory = transferZoneGroupFactory;
    }

    public TransferZoneGroupsImpl(TransferZoneGroupsImpl other) {
        super(other);
        this.transferZoneGroupFactory = other.transferZoneGroupFactory;
    }

    @Override
    public TransferZoneGroupFactory getFactory() {
        return this.transferZoneGroupFactory;
    }

    @Override
    public TransferZoneGroupsImpl clone() {
        return new TransferZoneGroupsImpl(this);
    }

    @Override
    public EventType[] getKnownSupportedEventTypes() {
        return new EventType[]{ModifiedZoneIdsEvent.EVENT_TYPE};
    }

    @Override
    public void onZoningModifierEvent(ZoningModificationEvent event) {
        if (event.getType().equals(ModifiedZoneIdsEvent.EVENT_TYPE)) {
            this.recreateTransferZoneGroupsZoneIdMapping();
        }
    }
}

