/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.BufferArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.Primitive32Array;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;

public final class Array1D<N extends Number>
extends AbstractList<N>
implements Access1D<N>,
Access1D.Elements,
Access1D.IndexOf,
Access1D.Sliceable<N>,
Access1D.Visitable<N>,
Access1D.Aggregatable<N>,
Mutate1D.Receiver<N>,
Mutate1D.BiModifiable<N>,
Mutate1D.Modifiable<N>,
Mutate1D.Mixable<N>,
Mutate1D.Sortable,
RandomAccess {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(BigArray.FACTORY);
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(ComplexArray.FACTORY);
    public static final Factory<Double> DIRECT32 = new Factory<Double>(BufferArray.DIRECT32);
    public static final Factory<Double> DIRECT64 = new Factory<Double>(BufferArray.DIRECT64);
    public static final Factory<Double> PRIMITIVE32 = new Factory<Double>(Primitive32Array.FACTORY);
    public static final Factory<Double> PRIMITIVE64 = new Factory<Double>(Primitive64Array.FACTORY);
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(QuaternionArray.FACTORY);
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(RationalArray.FACTORY);
    public final long length;
    private final BasicArray<N> myDelegate;
    private final long myFirst;
    private final long myLimit;
    private final long myStep;

    public static <N extends Number> Factory<N> factory(DenseArray.Factory<N> denseFactory) {
        return new Factory<N>(denseFactory);
    }

    Array1D(BasicArray<N> delegate) {
        this(delegate, 0L, delegate.count(), 1L);
    }

    Array1D(BasicArray<N> delegate, long first, long limit, long step) {
        this.myDelegate = delegate;
        this.myFirst = first;
        this.myLimit = limit;
        this.myStep = step;
        this.length = (this.myLimit - this.myFirst) / this.myStep;
    }

    @Override
    public void add(long index, double addend) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.add(tmpIndex, addend);
    }

    @Override
    public void add(long index, Number addend) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.add(tmpIndex, addend);
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return visitor.get();
    }

    @Override
    public void clear() {
        this.myDelegate.reset();
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) != -1;
    }

    public Array1D<N> copy() {
        PlainArray retVal = null;
        if (this.myDelegate.isPrimitive()) {
            retVal = new Primitive64Array((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, this.doubleValue(i));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof ComplexArray) {
            retVal = new ComplexArray((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, (Number)this.get(i));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof BigArray) {
            retVal = new BigArray((int)this.length);
            for (long i = 0L; i < this.length; ++i) {
                retVal.set(i, (Number)this.get(i));
            }
            return new Array1D<N>(retVal);
        }
        return null;
    }

    public Array1D<N> copy(int ... indices) {
        PlainArray retVal = null;
        int tmpLength = indices.length;
        if (this.myDelegate.isPrimitive()) {
            retVal = new Primitive64Array(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, this.doubleValue(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof ComplexArray) {
            retVal = new ComplexArray(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, (Number)this.get(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        if (this.myDelegate instanceof BigArray) {
            retVal = new BigArray(tmpLength);
            for (int i = 0; i < tmpLength; ++i) {
                retVal.set((long)i, (Number)this.get(indices[i]));
            }
            return new Array1D<Double>(retVal);
        }
        return null;
    }

    @Override
    public long count() {
        return this.length;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(this.myFirst + this.myStep * index);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(this.myFirst, this.myLimit, this.myStep, supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(this.myFirst + this.myStep * index, values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.fillOne(tmpIndex, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        long tmpIndex = this.myFirst + this.myStep * index;
        this.myDelegate.fillOne(tmpIndex, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.fill(tmpFirst, tmpLimit, this.myStep, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.fill(tmpFirst, tmpLimit, this.myStep, supplier);
    }

    @Override
    public N get(int index) {
        return this.myDelegate.get(this.myFirst + this.myStep * (long)index);
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(this.myFirst + this.myStep * index);
    }

    @Override
    public int indexOf(Object obj) {
        block3: {
            int tmpLength;
            block2: {
                tmpLength = (int)this.length;
                if (obj != null) break block2;
                for (int i = 0; i < tmpLength; ++i) {
                    if (this.get(i) != null) continue;
                    return i;
                }
                break block3;
            }
            if (!(obj instanceof Number)) break block3;
            for (int i = 0; i < tmpLength; ++i) {
                if (!obj.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public long indexOfLargest() {
        return this.indexOfLargestInRange(this.myFirst, this.myLimit);
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return (this.myDelegate.indexOfLargest(this.myFirst + this.myStep * first, this.myFirst + this.myStep * limit, this.myStep) - this.myFirst) / this.myStep;
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(this.myFirst + this.myStep * index);
    }

    @Override
    public boolean isAllSmall(double comparedTo) {
        return this.myDelegate.isSmall(this.myFirst, this.myLimit, this.myStep, comparedTo);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(this.myFirst + this.myStep * index, comparedTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long index, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            double oldValue = this.doubleValue(index);
            double newValue = mixer.invoke(oldValue, addend);
            this.set(index, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long index, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            N oldValue = this.get(index);
            N newValue = mixer.invoke(oldValue, addend);
            this.set(index, (Number)newValue);
            return newValue;
        }
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.myDelegate.modify(this.myFirst, this.myLimit, this.myStep, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long tmpLength = Math.min(this.length, left.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, function.invoke(left.doubleValue(i), this.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, (Number)function.invoke(left.get(i), this.get(i)));
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long tmpLength = Math.min(this.length, right.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, function.invoke(this.doubleValue(i), right.doubleValue(i)));
            }
        } else {
            for (long i = 0L; i < tmpLength; ++i) {
                this.set(i, (Number)function.invoke(this.get(i), right.get(i)));
            }
        }
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(this.myFirst + this.myStep * index, modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.modify(tmpFirst, tmpLimit, this.myStep, modifier);
    }

    @Override
    public N set(int index, Number value) {
        long tmpIndex = this.myFirst + this.myStep * (long)index;
        Object retVal = this.myDelegate.get(tmpIndex);
        this.myDelegate.set(tmpIndex, value);
        return retVal;
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(this.myFirst + this.myStep * index, value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(this.myFirst + this.myStep * index, value);
    }

    @Override
    public int size() {
        return (int)this.length;
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return new Array1D<N>(this.myDelegate, this.myFirst + this.myStep * first, this.myFirst + this.myStep * limit, this.myStep);
    }

    @Override
    public void sortAscending() {
        if (this.myDelegate instanceof Mutate1D.Sortable && this.count() == this.myDelegate.count()) {
            ((Mutate1D.Sortable)((Object)this.myDelegate)).sortAscending();
        } else {
            try {
                ForkJoinPool.commonPool().submit(new QuickAscendingSorter(this)).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void sortDescending() {
        if (this.myDelegate instanceof Mutate1D.Sortable && this.count() == this.myDelegate.count()) {
            ((Mutate1D.Sortable)((Object)this.myDelegate)).sortDescending();
        } else {
            try {
                ForkJoinPool.commonPool().submit(new QuickDescendingSorter(this)).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public Array1D<N> subList(int first, int limit) {
        return this.sliceRange(first, limit);
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(this.myFirst, this.myLimit, this.myStep, visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(this.myFirst + this.myStep * index, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        long tmpFirst = this.myFirst + this.myStep * first;
        long tmpLimit = this.myFirst + this.myStep * limit;
        this.myDelegate.visit(tmpFirst, tmpLimit, this.myStep, visitor);
    }

    void exchange(long indexA, long indexB) {
        if (this.myDelegate.isPrimitive()) {
            double tmpVal = this.doubleValue(indexA);
            this.set(indexA, this.doubleValue(indexB));
            this.set(indexB, tmpVal);
        } else {
            N tmpVal = this.get(indexA);
            this.set(indexA, (Number)this.get(indexB));
            this.set(indexB, (Number)tmpVal);
        }
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    void sortAscending(long low, long high) {
        long i = low;
        long j = high;
        double pivot = this.doubleValue(low + (high - low) / 2L);
        while (i <= j) {
            while (this.doubleValue(i) < pivot) {
                ++i;
            }
            while (this.doubleValue(j) > pivot) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.sortAscending(low, j);
        }
        if (i < high) {
            this.sortAscending(i, high);
        }
    }

    void sortDescending(long low, long high) {
        long i = low;
        long j = high;
        double pivot = this.doubleValue(low + (high - low) / 2L);
        while (i <= j) {
            while (this.doubleValue(i) > pivot) {
                ++i;
            }
            while (this.doubleValue(j) < pivot) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.sortDescending(low, j);
        }
        if (i < high) {
            this.sortDescending(i, high);
        }
    }

    static final class QuickDescendingSorter
    extends RecursiveAction {
        private final long high;
        private final long low;
        private final Array1D<?> myArray;

        private QuickDescendingSorter(Array1D<?> array, long low, long high) {
            this.myArray = array;
            this.low = low;
            this.high = high;
        }

        QuickDescendingSorter(Array1D<?> array) {
            this(array, 0L, array.count() - 1L);
        }

        @Override
        protected void compute() {
            long i = this.low;
            long j = this.high;
            double pivot = this.myArray.doubleValue(this.low + (this.high - this.low) / 2L);
            while (i <= j) {
                while (this.myArray.doubleValue(i) > pivot) {
                    ++i;
                }
                while (this.myArray.doubleValue(j) < pivot) {
                    --j;
                }
                if (i > j) continue;
                this.myArray.exchange(i, j);
                ++i;
                --j;
            }
            QuickDescendingSorter tmpPartL = null;
            ForkJoinTask tmpPartH = null;
            if (this.low < j) {
                tmpPartL = new QuickDescendingSorter(this.myArray, this.low, j);
                tmpPartL.fork();
            }
            if (i < this.high) {
                tmpPartH = new QuickDescendingSorter(this.myArray, i, this.high);
                tmpPartH.fork();
            }
            if (tmpPartL != null) {
                tmpPartL.join();
            }
            if (tmpPartH != null) {
                tmpPartH.join();
            }
        }
    }

    static final class QuickAscendingSorter
    extends RecursiveAction {
        private final long high;
        private final long low;
        private final Array1D<?> myArray;

        private QuickAscendingSorter(Array1D<?> array, long low, long high) {
            this.myArray = array;
            this.low = low;
            this.high = high;
        }

        QuickAscendingSorter(Array1D<?> array) {
            this(array, 0L, array.count() - 1L);
        }

        @Override
        protected void compute() {
            long i = this.low;
            long j = this.high;
            double pivot = this.myArray.doubleValue(this.low + (this.high - this.low) / 2L);
            while (i <= j) {
                while (this.myArray.doubleValue(i) < pivot) {
                    ++i;
                }
                while (this.myArray.doubleValue(j) > pivot) {
                    --j;
                }
                if (i > j) continue;
                this.myArray.exchange(i, j);
                ++i;
                --j;
            }
            QuickAscendingSorter tmpPartL = null;
            ForkJoinTask tmpPartH = null;
            if (this.low < j) {
                tmpPartL = new QuickAscendingSorter(this.myArray, this.low, j);
                tmpPartL.fork();
            }
            if (i < this.high) {
                tmpPartH = new QuickAscendingSorter(this.myArray, i, this.high);
                tmpPartH.fork();
            }
            if (tmpPartL != null) {
                tmpPartL.join();
            }
            if (tmpPartH != null) {
                tmpPartH.join();
            }
        }
    }

    public static final class Factory<N extends Number>
    implements Factory1D<Array1D<N>> {
        private final BasicArray.Factory<N> myDelegate;

        Factory(DenseArray.Factory<N> denseArray) {
            this.myDelegate = new BasicArray.Factory<N>(denseArray);
        }

        @Override
        public final Array1D<N> copy(Access1D<?> source) {
            return ((BasicArray)this.myDelegate.copy((Access1D)source)).wrapInArray1D();
        }

        @Override
        public final Array1D<N> copy(double ... source) {
            return ((BasicArray)this.myDelegate.copy(source)).wrapInArray1D();
        }

        @Override
        public final Array1D<N> copy(List<? extends Number> source) {
            return ((BasicArray)this.myDelegate.copy(source)).wrapInArray1D();
        }

        @Override
        public final Array1D<N> copy(Number ... source) {
            return ((BasicArray)this.myDelegate.copy(source)).wrapInArray1D();
        }

        public final FunctionSet<N> function() {
            return this.myDelegate.function();
        }

        @Override
        public final Array1D<N> makeFilled(long count, NullaryFunction<?> supplier) {
            return ((BasicArray)this.myDelegate.makeFilled(count, (NullaryFunction)supplier)).wrapInArray1D();
        }

        public final Array1D<N> makeSparse(long count) {
            return this.myDelegate.makeStructuredZero(count).wrapInArray1D();
        }

        @Override
        public final Array1D<N> makeZero(long count) {
            return this.myDelegate.makeToBeFilled(count).wrapInArray1D();
        }

        public final Scalar.Factory<N> scalar() {
            return this.myDelegate.scalar();
        }

        public final Array1D<N> wrap(BasicArray<N> array) {
            return array.wrapInArray1D();
        }
    }
}

