/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.GenericDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access2D;

abstract class EigenvalueDecomposition<N extends Number>
extends GenericDecomposition<N>
implements Eigenvalue<N> {
    private MatrixStore<N> myD = null;
    private Array1D<ComplexNumber> myEigenvalues = null;
    private MatrixStore<N> myV = null;
    private boolean myValuesOnly = false;

    static void sort(double[] d, ExchangeColumns mtrxV) {
        int size = d.length;
        int length = size - 1;
        for (int i = 0; i < length; ++i) {
            int k = i;
            double p = d[i];
            for (int j = i + 1; j < size; ++j) {
                if (!(d[j] > p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            mtrxV.exchangeColumns(i, k);
        }
    }

    protected EigenvalueDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public final boolean checkAndCompute(MatrixStore<N> matrix) {
        return this.compute(matrix, MatrixUtils.isHermitian(matrix), false);
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.compute(matrix, this.isHermitian(), true);
    }

    @Override
    public final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.compute(matrix, this.isHermitian(), false);
    }

    @Override
    public final MatrixStore<N> getD() {
        if (this.myD == null && this.isComputed()) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public final Array1D<ComplexNumber> getEigenvalues() {
        if (this.myEigenvalues == null && this.isComputed()) {
            this.myEigenvalues = this.makeEigenvalues();
        }
        return this.myEigenvalues;
    }

    @Override
    public final MatrixStore<N> getV() {
        if (this.myV == null && !this.myValuesOnly && this.isComputed()) {
            this.myV = this.makeV();
        }
        return this.myV;
    }

    @Override
    public void reset() {
        super.reset();
        this.myD = null;
        this.myEigenvalues = null;
        this.myV = null;
        this.myValuesOnly = false;
    }

    private final boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean hermitian, boolean valuesOnly) {
        this.reset();
        this.myValuesOnly = valuesOnly;
        boolean retVal = false;
        try {
            retVal = hermitian ? this.doHermitian(matrix, valuesOnly) : this.doGeneral(matrix, valuesOnly);
        }
        catch (Exception exc) {
            BasicLogger.error(exc.toString());
            this.reset();
            retVal = false;
        }
        return this.computed(retVal);
    }

    protected abstract boolean doGeneral(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, boolean var2);

    protected abstract boolean doHermitian(Access2D.Collectable<N, ? super PhysicalStore<N>> var1, boolean var2);

    protected abstract MatrixStore<N> makeD();

    protected abstract Array1D<ComplexNumber> makeEigenvalues();

    protected abstract MatrixStore<N> makeV();

    final void setD(MatrixStore<N> newD) {
        this.myD = newD;
    }

    final void setEigenvalues(Array1D<ComplexNumber> eigenvalues) {
        this.myEigenvalues = eigenvalues;
    }

    final void setV(MatrixStore<N> newV) {
        this.myV = newV;
    }
}

