/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.AbstractList;
import java.util.List;
import java.util.Vector;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.Raw1D;
import org.ojalgo.array.Raw2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.context.NumberContext;

public final class RawStore
implements PhysicalStore<Double> {
    public static PhysicalStore.Factory<Double, RawStore> FACTORY = new PhysicalStore.Factory<Double, RawStore>(){

        @Override
        public AggregatorSet<Double> aggregator() {
            return PrimitiveAggregator.getSet();
        }

        @Override
        public DenseArray.Factory<Double> array() {
            return Primitive64Array.FACTORY;
        }

        @Override
        public MatrixStore.Factory<Double> builder() {
            return MatrixStore.PRIMITIVE;
        }

        @Override
        public RawStore columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    retVal[i][j] = tmpColumn.doubleValue(i);
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    retVal[i][j] = tmpColumn[i];
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    retVal[i][j] = tmpColumn.get(i).doubleValue();
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    retVal[i][j] = tmpColumn[i].doubleValue();
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore conjugate(Access2D<?> source) {
            return this.transpose((Access2D)source);
        }

        @Override
        public RawStore copy(Access2D<?> source) {
            int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            MatrixUtils.copy(source, tmpRowDim, tmpColDim, retVal);
            return new RawStore(retVal, tmpRowDim, tmpColDim);
        }

        @Override
        public FunctionSet<Double> function() {
            return PrimitiveFunction.getSet();
        }

        @Override
        public RawStore makeEye(long rows, long columns) {
            RawStore retVal = this.makeZero(rows, columns);
            retVal.fillDiagonal(0L, 0L, (Double)this.scalar().one().get());
            return retVal;
        }

        @Override
        public RawStore makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            double[][] retVal = new double[(int)rows][(int)columns];
            int i = 0;
            while ((long)i < rows) {
                int j = 0;
                while ((long)j < columns) {
                    retVal[i][j] = supplier.doubleValue();
                    ++j;
                }
                ++i;
            }
            return new RawStore(retVal);
        }

        @Override
        public Householder<Double> makeHouseholder(int length) {
            return new Householder.Primitive(length);
        }

        @Override
        public Rotation<Double> makeRotation(int low, int high, double cos, double sin) {
            return new Rotation.Primitive(low, high, cos, sin);
        }

        @Override
        public Rotation<Double> makeRotation(int low, int high, Double cos, Double sin) {
            return new Rotation.Primitive(low, high, cos, sin);
        }

        @Override
        public RawStore makeZero(long rows, long columns) {
            return new RawStore(new double[(int)rows][(int)columns]);
        }

        @Override
        public RawStore rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpSource = source[i];
                double[] tmpDestination = retVal[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpDestination[j] = tmpSource.doubleValue(j);
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpSource = source[i];
                double[] tmpDestination = retVal[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpDestination[j] = tmpSource[j];
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpSource = source[i];
                double[] tmpDestination = retVal[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpDestination[j] = tmpSource.get(j).doubleValue();
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public RawStore rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpSource = source[i];
                double[] tmpDestination = retVal[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpDestination[j] = tmpSource[j].doubleValue();
                }
            }
            return new RawStore(retVal);
        }

        @Override
        public Scalar.Factory<Double> scalar() {
            return PrimitiveScalar.FACTORY;
        }

        @Override
        public RawStore transpose(Access2D<?> source) {
            int tmpRowDim = (int)source.countColumns();
            int tmpColDim = (int)source.countRows();
            double[][] retVal = new double[tmpRowDim][tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                for (int j = 0; j < tmpColDim; ++j) {
                    retVal[i][j] = source.doubleValue(j, i);
                }
            }
            return new RawStore(retVal);
        }
    };
    public final double[][] data;
    private final int myNumberOfColumns;

    public static RawStore constructWithCopy(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        RawStore X = new RawStore(m, n);
        double[][] C = X.data;
        for (int i = 0; i < m; ++i) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int j = 0; j < n; ++j) {
                C[i][j] = A[i][j];
            }
        }
        return X;
    }

    public static RawStore random(int m, int n) {
        RawStore A = new RawStore(m, n);
        double[][] X = A.data;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = Math.random();
            }
        }
        return A;
    }

    public static RawStore read(BufferedReader input) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Double> vD = new Vector<Double>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vD.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = vD.size();
        double[] row = new double[n];
        for (int j = 0; j < n; ++j) {
            row[j] = (Double)vD.elementAt(j);
        }
        Vector<double[]> v = new Vector<double[]>();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n];
            v.addElement(row);
            int j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j++] = Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        v.copyInto((Object[])A);
        return new RawStore(A);
    }

    private static RawStore convert(Access1D<?> elements, int structure) {
        RawStore retVal = null;
        retVal = elements instanceof RawStore ? (RawStore)elements : new RawStore(elements.toRawCopy1D(), structure);
        return retVal;
    }

    private static RawStore convert(Access2D<?> elements) {
        RawStore retVal = null;
        retVal = elements instanceof RawStore ? (RawStore)elements : new RawStore(elements.toRawCopy2D(), (int)elements.countRows(), (int)elements.countColumns());
        return retVal;
    }

    private static double[][] extract(Access1D<?> elements, int structure) {
        Object retVal = null;
        if (elements instanceof RawStore) {
            retVal = ((RawStore)elements).data;
        } else if (elements instanceof Access2D) {
            retVal = ((Access2D)elements).toRawCopy2D();
        } else {
            int tmpNumberOfColumns = (int)(structure != 0 ? elements.count() / (long)structure : 0L);
            if ((long)(structure * tmpNumberOfColumns) != elements.count()) {
                throw new IllegalArgumentException("Array length must be a multiple of structure.");
            }
            retVal = new double[structure][];
            for (int i = 0; i < structure; ++i) {
                retVal[i] = new double[tmpNumberOfColumns];
                double[] tmpRow = retVal[i];
                for (int j = 0; j < tmpNumberOfColumns; ++j) {
                    tmpRow[j] = elements.doubleValue(Structure2D.index(structure, i, j));
                }
            }
        }
        return retVal;
    }

    private static void multiply(double[][] product, double[][] left, double[][] right) {
        int tmpRowsCount = product.length;
        int tmpComplexity = right.length;
        int tmpColsCount = right[0].length;
        double[] tmpColumn = new double[tmpComplexity];
        for (int j = 0; j < tmpColsCount; ++j) {
            for (int k = 0; k < tmpComplexity; ++k) {
                tmpColumn[k] = right[k][j];
            }
            for (int i = 0; i < tmpRowsCount; ++i) {
                double[] tmpRow = left[i];
                double tmpVal = 0.0;
                for (int k = 0; k < tmpComplexity; ++k) {
                    tmpVal += tmpRow[k] * tmpColumn[k];
                }
                product[i][j] = tmpVal;
            }
        }
    }

    static Rotation.Primitive cast(Rotation<Double> aTransf) {
        if (aTransf instanceof Rotation.Primitive) {
            return (Rotation.Primitive)aTransf;
        }
        return new Rotation.Primitive(aTransf);
    }

    public RawStore(Access2D<?> template) {
        RawStore tmpConverted = RawStore.convert(template);
        this.data = tmpConverted.data;
        this.myNumberOfColumns = (int)template.countColumns();
    }

    public RawStore(double[] elements, int structure) {
        int n = this.myNumberOfColumns = structure != 0 ? elements.length / structure : 0;
        if (structure * this.myNumberOfColumns != elements.length) {
            throw new IllegalArgumentException("Array length must be a multiple of structure.");
        }
        this.data = new double[structure][this.myNumberOfColumns];
        for (int i = 0; i < structure; ++i) {
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                this.data[i][j] = elements[Structure2D.index(structure, i, j)];
            }
        }
    }

    public RawStore(double[][] A) {
        this.myNumberOfColumns = A[0].length;
        for (int i = 0; i < A.length; ++i) {
            if (A[i].length == this.myNumberOfColumns) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.data = A;
    }

    public RawStore(double[][] A, int m, int n) {
        this.data = A;
        this.myNumberOfColumns = n;
    }

    public RawStore(int m, int n) {
        this.myNumberOfColumns = n;
        this.data = new double[m][n];
    }

    public RawStore(int m, int n, double s) {
        this.myNumberOfColumns = n;
        this.data = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.data[i][j] = s;
            }
        }
    }

    private RawStore() {
        this.data = new double[0][0];
        this.myNumberOfColumns = 0;
        ProgrammingError.throwForIllegalInvocation();
    }

    RawStore(double[][] elements, int numberOfColumns) {
        this.data = elements;
        this.myNumberOfColumns = numberOfColumns;
    }

    @Override
    public void accept(Access2D<?> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.doubleValue(i, j));
            }
        }
    }

    @Override
    public void add(long row, long col, double addend) {
        double[] dArray = this.data[(int)row];
        int n = (int)col;
        dArray[n] = dArray[n] + addend;
    }

    @Override
    public void add(long row, long col, Number addend) {
        double[] dArray = this.data[(int)row];
        int n = (int)col;
        dArray[n] = dArray[n] + addend.doubleValue();
    }

    @Override
    public Double aggregateAll(Aggregator aggregator) {
        AggregatorFunction<Double> tmpVisitor = aggregator.getFunction(PrimitiveAggregator.getSet());
        this.visitAll((VoidFunction<Double>)tmpVisitor);
        return (Double)tmpVisitor.get();
    }

    @Override
    public List<Double> asList() {
        final int tmpStructure = this.data.length;
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return RawStore.this.get(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
            }

            @Override
            public Double set(int index, Double value) {
                int tmpRow = Structure2D.row(index, tmpStructure);
                int tmpColumn = Structure2D.column(index, tmpStructure);
                Double retVal = RawStore.this.get(tmpRow, tmpColumn);
                RawStore.this.set((long)tmpRow, (long)tmpColumn, value);
                return retVal;
            }

            @Override
            public int size() {
                return (int)RawStore.this.count();
            }
        };
    }

    @Override
    public RawStore conjugate() {
        return this.transpose();
    }

    public RawStore copy() {
        return new RawStore(this.copyOfData(), this.myNumberOfColumns);
    }

    public double[][] copyOfData() {
        int tmpLength = this.data.length;
        double[][] retVal = new double[tmpLength][];
        for (int i = 0; i < tmpLength; ++i) {
            retVal[i] = Raw1D.copyOf(this.data[i]);
        }
        return retVal;
    }

    @Override
    public long count() {
        return Structure2D.count(this.data.length, this.myNumberOfColumns);
    }

    @Override
    public long countColumns() {
        return this.myNumberOfColumns;
    }

    @Override
    public long countRows() {
        return this.data.length;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.data[(int)row][(int)col];
    }

    public boolean equals(Object other) {
        if (other instanceof Access2D) {
            return Access2D.equals(this, (Access2D)other, NumberContext.getGeneral(6));
        }
        return super.equals(other);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        Raw2D.exchangeColumns(this.data, (int)colA, (int)colB);
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        Raw2D.exchangeRows(this.data, (int)rowA, (int)rowB);
    }

    @Override
    public void fillAll(Double value) {
        Raw2D.fillAll(this.data, value);
    }

    @Override
    public void fillAll(NullaryFunction<Double> supplier) {
        Raw2D.fillAll(this.data, supplier);
    }

    @Override
    public void fillByMultiplying(Access1D<Double> leftMatrix, Access1D<Double> rightMatrix) {
        double[][] tmpLeft = RawStore.extract(leftMatrix, this.data.length);
        double[][] tmpRight = RawStore.extract(rightMatrix, (int)(leftMatrix.count() / (long)this.data.length));
        RawStore.multiply(this.data, tmpLeft, tmpRight);
    }

    @Override
    public void fillColumn(long row, long col, Double value) {
        Raw2D.fillColumn(this.data, (int)row, (int)col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<Double> supplier) {
        Raw2D.fillColumn(this.data, (int)row, (int)col, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, Double value) {
        Raw2D.fillDiagonal(this.data, (int)row, (int)col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<Double> supplier) {
        Raw2D.fillDiagonal(this.data, (int)row, (int)col, supplier);
    }

    @Override
    public void fillMatching(Access1D<?> source) {
        int tmpRowDim = this.data.length;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                tmpRowI[j] = source.doubleValue(Structure2D.index(tmpRowDim, i, j));
            }
        }
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left == this) {
            double[][] tmpRight = RawStore.convert(right, (int)this.data.length).data;
            if (function == PrimitiveFunction.ADD) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] + tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.DIVIDE) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] / tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.MULTIPLY) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] * tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.SUBTRACT) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] - tmpRight[i][j];
                    }
                }
            } else {
                Raw2D.fillMatching(this.data, this.data, function, tmpRight);
            }
        } else if (right == this) {
            double[][] tmpLeft = RawStore.convert(left, (int)this.data.length).data;
            if (function == PrimitiveFunction.ADD) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] + this.data[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.DIVIDE) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] / this.data[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.MULTIPLY) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] * this.data[i][j];
                    }
                }
            } else if (function == PrimitiveFunction.SUBTRACT) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] - this.data[i][j];
                    }
                }
            } else {
                Raw2D.fillMatching(this.data, tmpLeft, function, this.data);
            }
        } else {
            Raw2D.fillMatching(this.data, RawStore.convert(left, (int)this.data.length).data, function, RawStore.convert(right, (int)this.data.length).data);
        }
    }

    @Deprecated
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Double right) {
        Raw2D.fillMatching(this.data, RawStore.convert(left, (int)this.data.length).data, function, right);
    }

    @Deprecated
    public void fillMatching(Double left, BinaryFunction<Double> function, Access1D<Double> right) {
        Raw2D.fillMatching(this.data, left, function, RawStore.convert(right, (int)this.data.length).data);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, values.doubleValue(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, Double value) {
        this.data[(int)row][(int)col] = value;
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<Double> supplier) {
        this.data[(int)row][(int)col] = supplier.doubleValue();
    }

    @Override
    public void fillRange(long first, long limit, Double value) {
        Raw2D.fillRange(this.data, (int)first, (int)limit, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<Double> supplier) {
        Raw2D.fillRange(this.data, (int)first, (int)limit, supplier);
    }

    @Override
    public void fillRow(long row, long col, Double value) {
        Raw2D.fillRow(this.data, (int)row, (int)col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<Double> supplier) {
        Raw2D.fillRow(this.data, (int)row, (int)col, supplier);
    }

    @Override
    public final MatrixStore<Double> get() {
        return this;
    }

    @Override
    public Double get(long row, long col) {
        return this.data[(int)row][(int)col];
    }

    @Deprecated
    public RawStore getMatrix(int i0, int i1, int j0, int j1) {
        RawStore X = new RawStore(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.data;
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i - i0][j - j0] = this.data[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    @Deprecated
    public RawStore getMatrix(int[] r, int j0, int j1) {
        RawStore X = new RawStore(r.length, j1 - j0 + 1);
        double[][] B = X.data;
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    B[i][j - j0] = this.data[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public long indexOfLargest() {
        int tmpRowDim = this.data.length;
        int retVal = 0;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRow = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                double tmpValue = PrimitiveFunction.ABS.invoke(tmpRow[j]);
                if (!(tmpValue > tmpLargest)) continue;
                tmpLargest = tmpValue;
                retVal = Structure2D.index(tmpRowDim, i, j);
            }
        }
        return retVal;
    }

    @Override
    public long indexOfLargestInColumn(long row, long col) {
        int tmpRowDim = this.data.length;
        int retVal = (int)row;
        double tmpLargest = PrimitiveMath.ZERO;
        for (int i = (int)row; i < tmpRowDim; ++i) {
            double tmpValue = PrimitiveFunction.ABS.invoke(this.data[i][(int)col]);
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        int tmpRowDim = this.data.length;
        int retVal = 0;
        double tmpLargest = PrimitiveMath.ZERO;
        int index = 0;
        while ((long)index < this.count()) {
            int j;
            int i = Structure2D.row(index, tmpRowDim);
            double tmpValue = PrimitiveFunction.ABS.invoke(this.data[i][j = Structure2D.column(index, tmpRowDim)]);
            if (tmpValue > tmpLargest) {
                tmpLargest = tmpValue;
                retVal = index;
            }
            ++index;
        }
        return retVal;
    }

    @Override
    public long indexOfLargestInRow(long row, long col) {
        int retVal = (int)col;
        double tmpLargest = PrimitiveMath.ZERO;
        double[] tmpRow = this.data[(int)row];
        for (int j = (int)col; j < this.myNumberOfColumns; ++j) {
            double tmpValue = PrimitiveFunction.ABS.invoke(tmpRow[j]);
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = j;
        }
        return retVal;
    }

    @Override
    public long indexOfLargestOnDiagonal(long first) {
        int tmpRowDim = this.data.length;
        int retVal = (int)first;
        double tmpLargest = PrimitiveMath.ZERO;
        int i = (int)first;
        for (int j = (int)first; i < tmpRowDim && j < this.myNumberOfColumns; ++i, ++j) {
            double tmpValue = PrimitiveFunction.ABS.invoke(this.data[i][j]);
            if (!(tmpValue > tmpLargest)) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    public boolean isAbsolute(long index) {
        int tmpRowDim = this.data.length;
        return PrimitiveScalar.isAbsolute(this.get(Structure2D.row(index, tmpRowDim), Structure2D.column(index, tmpRowDim)));
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return PrimitiveScalar.isAbsolute(this.get((int)row, (int)col));
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        int tmpRowDim = this.data.length;
        return PrimitiveScalar.isSmall(comparedTo, this.get(Structure2D.row(index, tmpRowDim), Structure2D.column(index, tmpRowDim)));
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.doubleValue(row, col));
    }

    @Override
    public void modifyAll(UnaryFunction<Double> modifier) {
        Raw2D.modifyAll(this.data, modifier);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<Double> modifier) {
        Raw2D.modifyColumn(this.data, (int)row, (int)col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<Double> modifier) {
        long tmpCount = Math.min((long)this.data.length - row, (long)this.myNumberOfColumns - col);
        int tmpFirst = (int)(row + col * (long)this.data.length);
        int tmpLimit = (int)(row + tmpCount + (col + tmpCount) * (long)this.data.length);
        int tmpStep = 1 + this.data.length;
        for (int ij = tmpFirst; ij < tmpLimit; ij += tmpStep) {
            this.set((long)ij, modifier.invoke(this.doubleValue(ij)));
        }
    }

    @Override
    public void modifyMatching(Access1D<Double> left, BinaryFunction<Double> function) {
        int tmpRowDim = this.data.length;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                tmpRowI[j] = function.invoke(left.doubleValue(Structure2D.index(tmpRowDim, i, j)), tmpRowI[j]);
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<Double> function, Access1D<Double> right) {
        int tmpRowDim = this.data.length;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                tmpRowI[j] = function.invoke(tmpRowI[j], right.doubleValue(Structure2D.index(tmpRowDim, i, j)));
            }
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<Double> modifier) {
        double tmpValue = this.doubleValue(row, col);
        tmpValue = modifier.invoke(tmpValue);
        this.set(row, col, tmpValue);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<Double> modifier) {
        for (long index = first; index < limit; ++index) {
            this.set(index, modifier.invoke(this.doubleValue(index)));
        }
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<Double> modifier) {
        Raw2D.modifyRow(this.data, (int)row, (int)col, modifier);
    }

    @Override
    public RawStore multiply(MatrixStore<Double> right) {
        int tmpRowDim = this.data.length;
        int tmpComplexity = this.myNumberOfColumns;
        int tmpColDim = (int)(right.count() / (long)tmpComplexity);
        RawStore retVal = new RawStore(tmpRowDim, tmpColDim);
        double[][] tmpRight = RawStore.extract(right, tmpComplexity);
        RawStore.multiply(retVal.data, this.data, tmpRight);
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.makeZero(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public PhysicalStore.Factory<Double, RawStore> physical() {
        return FACTORY;
    }

    @Override
    public final ElementsConsumer<Double> regionByColumns(int ... columns) {
        return new ElementsConsumer.ColumnsRegion<Double>(this, MultiplyBoth.getPrimitive(this.data.length, this.myNumberOfColumns), columns);
    }

    @Override
    public final ElementsConsumer<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new ElementsConsumer.LimitRegion<Double>(this, MultiplyBoth.getPrimitive(this.data.length, this.myNumberOfColumns), rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new ElementsConsumer.OffsetRegion<Double>(this, MultiplyBoth.getPrimitive(this.data.length, this.myNumberOfColumns), rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<Double> regionByRows(int ... rows) {
        return new ElementsConsumer.RowsRegion<Double>(this, MultiplyBoth.getPrimitive(this.data.length, this.myNumberOfColumns), rows);
    }

    @Override
    public final ElementsConsumer<Double> regionByTransposing() {
        return new ElementsConsumer.TransposedRegion<Double>(this, MultiplyBoth.getPrimitive(this.data.length, this.myNumberOfColumns));
    }

    @Override
    public void set(long row, long col, double value) {
        this.data[(int)row][(int)col] = value;
    }

    @Override
    public void set(long row, long col, Number value) {
        this.data[(int)row][(int)col] = value.doubleValue();
    }

    @Override
    public void substituteBackwards(Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
    }

    @Override
    public void substituteForwards(Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
    }

    @Override
    public void supplyTo(ElementsConsumer<Double> receiver) {
        receiver.fillMatching(this);
    }

    public PrimitiveScalar toScalar(long row, long column) {
        return PrimitiveScalar.of(this.doubleValue(row, column));
    }

    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        double[][] tmpArray = this.data;
        int tmpRowDim = this.data.length;
        int tmpColDim = this.myNumberOfColumns;
        int tmpFirst = transformation.first();
        double[] tmpWorkCopy = new double[(int)transformation.count()];
        for (int j = firstColumn; j < tmpColDim; ++j) {
            double tmpScale = PrimitiveMath.ZERO;
            for (int i = tmpFirst; i < tmpRowDim; ++i) {
                tmpScale += tmpWorkCopy[i] * tmpArray[i][j];
            }
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)transformation.count();
            for (int i1 = transformation.first(); i1 < tmpSize; ++i1) {
                double tmpVal = transformation.doubleValue(i1);
                tmpVal2 += tmpVal * tmpVal;
                tmpWorkCopy[i1] = tmpVal;
            }
            tmpScale *= PrimitiveMath.TWO / tmpVal2;
            for (int i = tmpFirst; i < tmpRowDim; ++i) {
                double[] dArray = tmpArray[i];
                int n = j;
                dArray[n] = dArray[n] - tmpScale * tmpWorkCopy[i];
            }
        }
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = RawStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                double[][] tmpArray = this.data;
                for (int j = 0; j < tmpArray[0].length; ++j) {
                    double tmpOldLow = tmpArray[tmpLow][j];
                    double tmpOldHigh = tmpArray[tmpHigh][j];
                    tmpArray[tmpLow][j] = tmpTransf.cos * tmpOldLow + tmpTransf.sin * tmpOldHigh;
                    tmpArray[tmpHigh][j] = tmpTransf.cos * tmpOldHigh - tmpTransf.sin * tmpOldLow;
                }
            } else {
                this.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.modifyRow((long)tmpLow, 0L, (UnaryFunction<Double>)PrimitiveFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.modifyRow((long)tmpLow, 0L, (UnaryFunction<Double>)PrimitiveFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.modifyRow((long)tmpLow, 0L, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        double[][] tmpArray = this.data;
        int tmpRowDim = this.data.length;
        int tmpColDim = this.myNumberOfColumns;
        int tmpFirst = transformation.first();
        double[] tmpWorkCopy = new double[(int)transformation.count()];
        for (int i = firstRow; i < tmpRowDim; ++i) {
            double tmpScale = PrimitiveMath.ZERO;
            for (int j = tmpFirst; j < tmpColDim; ++j) {
                tmpScale += tmpWorkCopy[j] * tmpArray[i][j];
            }
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)transformation.count();
            for (int i1 = transformation.first(); i1 < tmpSize; ++i1) {
                double tmpVal = transformation.doubleValue(i1);
                tmpVal2 += tmpVal * tmpVal;
                tmpWorkCopy[i1] = tmpVal;
            }
            tmpScale *= PrimitiveMath.TWO / tmpVal2;
            for (int j = tmpFirst; j < tmpColDim; ++j) {
                double[] dArray = tmpArray[i];
                int n = j;
                dArray[n] = dArray[n] - tmpScale * tmpWorkCopy[j];
            }
        }
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = RawStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                double[][] tmpArray = this.data;
                for (int i = 0; i < tmpArray.length; ++i) {
                    double tmpOldLow = tmpArray[i][tmpLow];
                    double tmpOldHigh = tmpArray[i][tmpHigh];
                    tmpArray[i][tmpLow] = tmpTransf.cos * tmpOldLow - tmpTransf.sin * tmpOldHigh;
                    tmpArray[i][tmpHigh] = tmpTransf.cos * tmpOldHigh + tmpTransf.sin * tmpOldLow;
                }
            } else {
                this.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.modifyColumn(0L, (long)tmpHigh, (UnaryFunction<Double>)PrimitiveFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.modifyColumn(0L, (long)tmpHigh, (UnaryFunction<Double>)PrimitiveFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.modifyColumn(0L, (long)tmpHigh, PrimitiveFunction.NEGATE);
        }
    }

    @Override
    public RawStore transpose() {
        RawStore retVal = new RawStore(this.myNumberOfColumns, this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                retVal.data[j][i] = this.data[i][j];
            }
        }
        return retVal;
    }

    @Override
    public void visitAll(VoidFunction<Double> visitor) {
        Raw2D.visitAll(this.data, visitor);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<Double> visitor) {
        Raw2D.visitColumn(this.data, (int)row, (int)col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<Double> visitor) {
        Raw2D.visitDiagonal(this.data, (int)row, (int)col, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<Double> visitor) {
        Raw2D.visitRange(this.data, (int)first, (int)limit, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<Double> visitor) {
        Raw2D.visitRow(this.data, (int)row, (int)col, visitor);
    }
}

