# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from platform_api_python_client.models.c_serve_recipe_input import CServeRecipeInput
from typing import Optional, Set
from typing_extensions import Self

class CreateCServeDeploymentRequest(BaseModel):
    """
    CreateCServeDeploymentRequest
    """ # noqa: E501
    name: StrictStr
    cluster_id: StrictInt
    hardware_instance_id: StrictInt
    recipe: CServeRecipeInput
    hf_token: StrictStr
    endpoint_certificate_authority: Optional[StrictStr] = None
    min_scale: StrictInt
    max_scale: StrictInt
    concurrency: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["name", "cluster_id", "hardware_instance_id", "recipe", "hf_token", "endpoint_certificate_authority", "min_scale", "max_scale", "concurrency"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCServeDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of recipe
        if self.recipe:
            _dict['recipe'] = self.recipe.to_dict()
        # set to None if endpoint_certificate_authority (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_certificate_authority is None and "endpoint_certificate_authority" in self.model_fields_set:
            _dict['endpoint_certificate_authority'] = None

        # set to None if concurrency (nullable) is None
        # and model_fields_set contains the field
        if self.concurrency is None and "concurrency" in self.model_fields_set:
            _dict['concurrency'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCServeDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "cluster_id": obj.get("cluster_id"),
            "hardware_instance_id": obj.get("hardware_instance_id"),
            "recipe": CServeRecipeInput.from_dict(obj["recipe"]) if obj.get("recipe") is not None else None,
            "hf_token": obj.get("hf_token"),
            "endpoint_certificate_authority": obj.get("endpoint_certificate_authority"),
            "min_scale": obj.get("min_scale"),
            "max_scale": obj.get("max_scale"),
            "concurrency": obj.get("concurrency")
        })
        return _obj


