# platform-api-python-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.2.0
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/centml/platform/client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/centml/platform/client.git`)

Then import the package:
```python
import platform_api_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import platform_api_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import platform_api_python_client
from platform_api_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = platform_api_python_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = platform_api_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with platform_api_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = platform_api_python_client.EXTERNALApi(api_client)
    feedback_request = platform_api_python_client.FeedbackRequest() # FeedbackRequest | 

    try:
        # Add Feedback Request
        api_response = api_instance.add_feedback_request_support_feedback_post(feedback_request)
        print("The response of EXTERNALApi->add_feedback_request_support_feedback_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EXTERNALApi->add_feedback_request_support_feedback_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EXTERNALApi* | [**add_feedback_request_support_feedback_post**](docs/EXTERNALApi.md#add_feedback_request_support_feedback_post) | **POST** /support/feedback | Add Feedback Request
*EXTERNALApi* | [**create_api_key_credentials_api_key_post**](docs/EXTERNALApi.md#create_api_key_credentials_api_key_post) | **POST** /credentials/api-key | Create Api Key
*EXTERNALApi* | [**create_compute_deployment_deployments_v2_compute_post**](docs/EXTERNALApi.md#create_compute_deployment_deployments_v2_compute_post) | **POST** /deployments/v2/compute | Create Compute Deployment
*EXTERNALApi* | [**create_cserve_deployment_deployments_v2_cserve_post**](docs/EXTERNALApi.md#create_cserve_deployment_deployments_v2_cserve_post) | **POST** /deployments/v2/cserve | Create Cserve Deployment
*EXTERNALApi* | [**create_hardware_request_support_hardware_request_post**](docs/EXTERNALApi.md#create_hardware_request_support_hardware_request_post) | **POST** /support/hardware-request | Create Hardware Request
*EXTERNALApi* | [**create_inference_deployment_deployments_v2_inference_post**](docs/EXTERNALApi.md#create_inference_deployment_deployments_v2_inference_post) | **POST** /deployments/v2/inference | Create Inference Deployment
*EXTERNALApi* | [**create_payment_payments_post**](docs/EXTERNALApi.md#create_payment_payments_post) | **POST** /payments | Create Payment
*EXTERNALApi* | [**create_payment_setup_payments_setup_post**](docs/EXTERNALApi.md#create_payment_setup_payments_setup_post) | **POST** /payments/setup | Create Payment Setup
*EXTERNALApi* | [**delete_api_key_credentials_api_key_id_delete**](docs/EXTERNALApi.md#delete_api_key_credentials_api_key_id_delete) | **DELETE** /credentials/api-key/{id} | Delete Api Key
*EXTERNALApi* | [**delete_payment_method_payments_methods_payment_method_delete**](docs/EXTERNALApi.md#delete_payment_method_payments_methods_payment_method_delete) | **DELETE** /payments/methods/{payment_method} | Delete Payment Method
*EXTERNALApi* | [**get_api_keys_credentials_api_key_get**](docs/EXTERNALApi.md#get_api_keys_credentials_api_key_get) | **GET** /credentials/api-key | Get Api Keys
*EXTERNALApi* | [**get_clusters_clusters_get**](docs/EXTERNALApi.md#get_clusters_clusters_get) | **GET** /clusters | Get Clusters
*EXTERNALApi* | [**get_compute_deployment_deployments_v2_compute_deployment_id_get**](docs/EXTERNALApi.md#get_compute_deployment_deployments_v2_compute_deployment_id_get) | **GET** /deployments/v2/compute/{deployment_id} | Get Compute Deployment
*EXTERNALApi* | [**get_credits_credits_get**](docs/EXTERNALApi.md#get_credits_credits_get) | **GET** /credits | Get Credits
*EXTERNALApi* | [**get_cserve_deployment_deployments_v2_cserve_deployment_id_get**](docs/EXTERNALApi.md#get_cserve_deployment_deployments_v2_cserve_deployment_id_get) | **GET** /deployments/v2/cserve/{deployment_id} | Get Cserve Deployment
*EXTERNALApi* | [**get_cserve_recipe_deployments_v2_cserve_recipes_get**](docs/EXTERNALApi.md#get_cserve_recipe_deployments_v2_cserve_recipes_get) | **GET** /deployments/v2/cserve/recipes | Get Cserve Recipe
*EXTERNALApi* | [**get_deployment_logs_deployments_logs_deployment_id_get**](docs/EXTERNALApi.md#get_deployment_logs_deployments_logs_deployment_id_get) | **GET** /deployments/logs/{deployment_id} | Get Deployment Logs
*EXTERNALApi* | [**get_deployment_status_deployments_v2_status_deployment_id_get**](docs/EXTERNALApi.md#get_deployment_status_deployments_v2_status_deployment_id_get) | **GET** /deployments/v2/status/{deployment_id} | Get Deployment Status
*EXTERNALApi* | [**get_deployments_deployments_v2_get**](docs/EXTERNALApi.md#get_deployments_deployments_v2_get) | **GET** /deployments/v2 | Get Deployments
*EXTERNALApi* | [**get_hardware_instances_hardware_instances_get**](docs/EXTERNALApi.md#get_hardware_instances_hardware_instances_get) | **GET** /hardware-instances | Get Hardware Instances
*EXTERNALApi* | [**get_hardware_instances_hardware_instances_v2_get**](docs/EXTERNALApi.md#get_hardware_instances_hardware_instances_v2_get) | **GET** /hardware-instances/v2 | Get Hardware Instances
*EXTERNALApi* | [**get_inference_deployment_deployments_v2_inference_deployment_id_get**](docs/EXTERNALApi.md#get_inference_deployment_deployments_v2_inference_deployment_id_get) | **GET** /deployments/v2/inference/{deployment_id} | Get Inference Deployment
*EXTERNALApi* | [**get_payment_methods_payments_methods_get**](docs/EXTERNALApi.md#get_payment_methods_payments_methods_get) | **GET** /payments/methods | Get Payment Methods
*EXTERNALApi* | [**get_prebuilt_images_prebuilt_images_get**](docs/EXTERNALApi.md#get_prebuilt_images_prebuilt_images_get) | **GET** /prebuilt-images | Get Prebuilt Images
*EXTERNALApi* | [**get_usage_daily_bills_get**](docs/EXTERNALApi.md#get_usage_daily_bills_get) | **GET** /daily_bills | Get Usage
*EXTERNALApi* | [**get_usage_deployments_usage_deployment_id_get**](docs/EXTERNALApi.md#get_usage_deployments_usage_deployment_id_get) | **GET** /deployments/usage/{deployment_id} | Get Usage
*EXTERNALApi* | [**update_deployment_status_deployments_v2_status_deployment_id_put**](docs/EXTERNALApi.md#update_deployment_status_deployments_v2_status_deployment_id_put) | **PUT** /deployments/v2/status/{deployment_id} | Update Deployment Status


## Documentation For Models

 - [APIKeyRequest](docs/APIKeyRequest.md)
 - [APIKeyResponse](docs/APIKeyResponse.md)
 - [AddHardwareRequest](docs/AddHardwareRequest.md)
 - [CServeRecipeInput](docs/CServeRecipeInput.md)
 - [CServeRecipeOutput](docs/CServeRecipeOutput.md)
 - [CServeRecipePerf](docs/CServeRecipePerf.md)
 - [CServeRecipeResponse](docs/CServeRecipeResponse.md)
 - [ClientSecretResponse](docs/ClientSecretResponse.md)
 - [CreateCServeDeploymentRequest](docs/CreateCServeDeploymentRequest.md)
 - [CreateCServeDeploymentResponse](docs/CreateCServeDeploymentResponse.md)
 - [CreateComputeDeploymentResponse](docs/CreateComputeDeploymentResponse.md)
 - [CreateComputeDeploymentV2Request](docs/CreateComputeDeploymentV2Request.md)
 - [CreateInferenceDeploymentResponse](docs/CreateInferenceDeploymentResponse.md)
 - [CreateInferenceDeploymentV2Request](docs/CreateInferenceDeploymentV2Request.md)
 - [CreatePaymentRequest](docs/CreatePaymentRequest.md)
 - [CreditsResponse](docs/CreditsResponse.md)
 - [DailyBillResponse](docs/DailyBillResponse.md)
 - [DeploymentStatus](docs/DeploymentStatus.md)
 - [DeploymentStatusRequest](docs/DeploymentStatusRequest.md)
 - [DeploymentStatusResponseV2](docs/DeploymentStatusResponseV2.md)
 - [DeploymentType](docs/DeploymentType.md)
 - [DeploymentUsageValue](docs/DeploymentUsageValue.md)
 - [FeedbackRequest](docs/FeedbackRequest.md)
 - [GetCServeDeploymentResponse](docs/GetCServeDeploymentResponse.md)
 - [GetClusterResponse](docs/GetClusterResponse.md)
 - [GetComputeV2DeploymentResponse](docs/GetComputeV2DeploymentResponse.md)
 - [GetDeploymentLogResponse](docs/GetDeploymentLogResponse.md)
 - [GetDeploymentUsageResponse](docs/GetDeploymentUsageResponse.md)
 - [GetDeploymentV2Response](docs/GetDeploymentV2Response.md)
 - [GetInferenceV2DeploymentResponse](docs/GetInferenceV2DeploymentResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HardwareInstanceResponse](docs/HardwareInstanceResponse.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [ListAPIKeyResponse](docs/ListAPIKeyResponse.md)
 - [ListCServeRecipeResponse](docs/ListCServeRecipeResponse.md)
 - [ListDailyBillResponse](docs/ListDailyBillResponse.md)
 - [ListGetClusterResponse](docs/ListGetClusterResponse.md)
 - [ListGetDeploymentV2Response](docs/ListGetDeploymentV2Response.md)
 - [ListHardwareInstanceResponse](docs/ListHardwareInstanceResponse.md)
 - [ListPaymentMethodResponse](docs/ListPaymentMethodResponse.md)
 - [ListPrebuiltImageResponse](docs/ListPrebuiltImageResponse.md)
 - [Metric](docs/Metric.md)
 - [PrebuiltImageResponse](docs/PrebuiltImageResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication


## Author




