# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CServeV2RecipeInput(BaseModel):
    """
    Inputs to start deployment
    """ # noqa: E501
    model: StrictStr
    max_model_len: Optional[StrictInt] = None
    is_embedding_model: Optional[StrictBool] = False
    tokenizer: StrictStr
    tensor_parallel_size: StrictInt
    pipeline_parallel_size: StrictInt
    gpu_mem_util: Optional[Union[StrictFloat, StrictInt]] = 0.95
    block_size: Optional[StrictInt] = 16
    swap_space: Optional[StrictInt] = 0
    quantization: Optional[StrictStr] = None
    dtype: Optional[StrictStr] = 'auto'
    cache_dtype: Optional[StrictStr] = 'auto'
    max_num_seqs: Optional[StrictInt] = 256
    eager_execution: Optional[StrictBool] = True
    use_flashinfer: Optional[StrictBool] = False
    offloading_num: Optional[Union[StrictFloat, StrictInt]] = 0
    spec_draft_model: Optional[StrictStr] = None
    spec_tokens: Optional[StrictInt] = None
    spec_prompt_lookup_max: Optional[StrictInt] = None
    spec_prompt_lookup_min: Optional[StrictInt] = None
    use_prefix_caching: Optional[StrictBool] = False
    use_chunked_prefill: Optional[StrictBool] = False
    chunked_prefill_size: Optional[StrictInt] = None
    max_seq_len_to_capture: Optional[StrictInt] = 8192
    distributed_executor_backend: Optional[StrictStr] = 'mp'
    spec_max_batch_size: Optional[StrictInt] = None
    spec_max_seq_len: Optional[StrictInt] = None
    num_scheduler_steps: Optional[StrictInt] = 1
    __properties: ClassVar[List[str]] = ["model", "max_model_len", "is_embedding_model", "tokenizer", "tensor_parallel_size", "pipeline_parallel_size", "gpu_mem_util", "block_size", "swap_space", "quantization", "dtype", "cache_dtype", "max_num_seqs", "eager_execution", "use_flashinfer", "offloading_num", "spec_draft_model", "spec_tokens", "spec_prompt_lookup_max", "spec_prompt_lookup_min", "use_prefix_caching", "use_chunked_prefill", "chunked_prefill_size", "max_seq_len_to_capture", "distributed_executor_backend", "spec_max_batch_size", "spec_max_seq_len", "num_scheduler_steps"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CServeV2RecipeInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if max_model_len (nullable) is None
        # and model_fields_set contains the field
        if self.max_model_len is None and "max_model_len" in self.model_fields_set:
            _dict['max_model_len'] = None

        # set to None if quantization (nullable) is None
        # and model_fields_set contains the field
        if self.quantization is None and "quantization" in self.model_fields_set:
            _dict['quantization'] = None

        # set to None if spec_draft_model (nullable) is None
        # and model_fields_set contains the field
        if self.spec_draft_model is None and "spec_draft_model" in self.model_fields_set:
            _dict['spec_draft_model'] = None

        # set to None if spec_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.spec_tokens is None and "spec_tokens" in self.model_fields_set:
            _dict['spec_tokens'] = None

        # set to None if spec_prompt_lookup_max (nullable) is None
        # and model_fields_set contains the field
        if self.spec_prompt_lookup_max is None and "spec_prompt_lookup_max" in self.model_fields_set:
            _dict['spec_prompt_lookup_max'] = None

        # set to None if spec_prompt_lookup_min (nullable) is None
        # and model_fields_set contains the field
        if self.spec_prompt_lookup_min is None and "spec_prompt_lookup_min" in self.model_fields_set:
            _dict['spec_prompt_lookup_min'] = None

        # set to None if chunked_prefill_size (nullable) is None
        # and model_fields_set contains the field
        if self.chunked_prefill_size is None and "chunked_prefill_size" in self.model_fields_set:
            _dict['chunked_prefill_size'] = None

        # set to None if spec_max_batch_size (nullable) is None
        # and model_fields_set contains the field
        if self.spec_max_batch_size is None and "spec_max_batch_size" in self.model_fields_set:
            _dict['spec_max_batch_size'] = None

        # set to None if spec_max_seq_len (nullable) is None
        # and model_fields_set contains the field
        if self.spec_max_seq_len is None and "spec_max_seq_len" in self.model_fields_set:
            _dict['spec_max_seq_len'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CServeV2RecipeInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "model": obj.get("model"),
            "max_model_len": obj.get("max_model_len"),
            "is_embedding_model": obj.get("is_embedding_model") if obj.get("is_embedding_model") is not None else False,
            "tokenizer": obj.get("tokenizer"),
            "tensor_parallel_size": obj.get("tensor_parallel_size"),
            "pipeline_parallel_size": obj.get("pipeline_parallel_size"),
            "gpu_mem_util": obj.get("gpu_mem_util") if obj.get("gpu_mem_util") is not None else 0.95,
            "block_size": obj.get("block_size") if obj.get("block_size") is not None else 16,
            "swap_space": obj.get("swap_space") if obj.get("swap_space") is not None else 0,
            "quantization": obj.get("quantization"),
            "dtype": obj.get("dtype") if obj.get("dtype") is not None else 'auto',
            "cache_dtype": obj.get("cache_dtype") if obj.get("cache_dtype") is not None else 'auto',
            "max_num_seqs": obj.get("max_num_seqs") if obj.get("max_num_seqs") is not None else 256,
            "eager_execution": obj.get("eager_execution") if obj.get("eager_execution") is not None else True,
            "use_flashinfer": obj.get("use_flashinfer") if obj.get("use_flashinfer") is not None else False,
            "offloading_num": obj.get("offloading_num") if obj.get("offloading_num") is not None else 0,
            "spec_draft_model": obj.get("spec_draft_model"),
            "spec_tokens": obj.get("spec_tokens"),
            "spec_prompt_lookup_max": obj.get("spec_prompt_lookup_max"),
            "spec_prompt_lookup_min": obj.get("spec_prompt_lookup_min"),
            "use_prefix_caching": obj.get("use_prefix_caching") if obj.get("use_prefix_caching") is not None else False,
            "use_chunked_prefill": obj.get("use_chunked_prefill") if obj.get("use_chunked_prefill") is not None else False,
            "chunked_prefill_size": obj.get("chunked_prefill_size"),
            "max_seq_len_to_capture": obj.get("max_seq_len_to_capture") if obj.get("max_seq_len_to_capture") is not None else 8192,
            "distributed_executor_backend": obj.get("distributed_executor_backend") if obj.get("distributed_executor_backend") is not None else 'mp',
            "spec_max_batch_size": obj.get("spec_max_batch_size"),
            "spec_max_seq_len": obj.get("spec_max_seq_len"),
            "num_scheduler_steps": obj.get("num_scheduler_steps") if obj.get("num_scheduler_steps") is not None else 1
        })
        return _obj


