# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateInferenceDeploymentRequest(BaseModel):
    """
    CreateInferenceDeploymentRequest
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=20)]
    cluster_id: StrictInt
    hardware_instance_id: StrictInt
    image_url: StrictStr
    port: StrictInt
    min_scale: StrictInt
    max_scale: StrictInt
    concurrency: Optional[StrictInt] = None
    healthcheck: Optional[StrictStr] = None
    env_vars: Optional[Dict[str, StrictStr]] = None
    command: Optional[StrictStr] = None
    endpoint_certificate_authority: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["name", "cluster_id", "hardware_instance_id", "image_url", "port", "min_scale", "max_scale", "concurrency", "healthcheck", "env_vars", "command", "endpoint_certificate_authority"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z][a-z0-9-]*$", value):
            raise ValueError(r"must validate the regular expression /^[a-z][a-z0-9-]*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInferenceDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if concurrency (nullable) is None
        # and model_fields_set contains the field
        if self.concurrency is None and "concurrency" in self.model_fields_set:
            _dict['concurrency'] = None

        # set to None if healthcheck (nullable) is None
        # and model_fields_set contains the field
        if self.healthcheck is None and "healthcheck" in self.model_fields_set:
            _dict['healthcheck'] = None

        # set to None if env_vars (nullable) is None
        # and model_fields_set contains the field
        if self.env_vars is None and "env_vars" in self.model_fields_set:
            _dict['env_vars'] = None

        # set to None if command (nullable) is None
        # and model_fields_set contains the field
        if self.command is None and "command" in self.model_fields_set:
            _dict['command'] = None

        # set to None if endpoint_certificate_authority (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_certificate_authority is None and "endpoint_certificate_authority" in self.model_fields_set:
            _dict['endpoint_certificate_authority'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInferenceDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "cluster_id": obj.get("cluster_id"),
            "hardware_instance_id": obj.get("hardware_instance_id"),
            "image_url": obj.get("image_url"),
            "port": obj.get("port"),
            "min_scale": obj.get("min_scale"),
            "max_scale": obj.get("max_scale"),
            "concurrency": obj.get("concurrency"),
            "healthcheck": obj.get("healthcheck"),
            "env_vars": obj.get("env_vars"),
            "command": obj.get("command"),
            "endpoint_certificate_authority": obj.get("endpoint_certificate_authority")
        })
        return _obj


