# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CServeRecipe(BaseModel):
    """
    Base class for deployment planner
    """ # noqa: E501
    model: StrictStr
    is_embedding_model: Optional[StrictBool] = False
    tensor_parallel_size: StrictInt
    pipeline_parallel_size: StrictInt
    block_size: Optional[StrictInt] = 32
    swap_space: Optional[Annotated[int, Field(strict=True, ge=0)]] = 0
    gpu_mem_util: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = 0.95
    max_num_seqs: Optional[StrictInt] = 256
    offloading_num: Optional[StrictInt] = 0
    use_prefix_caching: Optional[StrictBool] = None
    use_chunked_prefill: Optional[StrictBool] = None
    chunked_prefill_size: Optional[StrictInt] = None
    eager_execution: Optional[StrictBool] = None
    num_scheduler_steps: Optional[StrictInt] = None
    use_flashinfer: Optional[StrictBool] = False
    max_model_len: Optional[Annotated[int, Field(strict=True, ge=128)]] = None
    dtype: Optional[StrictStr] = 'auto'
    tokenizer: Optional[StrictStr] = None
    spec_proposer: Optional[StrictStr] = None
    spec_draft_model: Optional[StrictStr] = None
    spec_tokens: Optional[StrictInt] = None
    spec_prompt_lookup_min: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    spec_prompt_lookup_max: Optional[Annotated[int, Field(strict=True, ge=1)]] = None
    seed: Optional[StrictInt] = 0
    __properties: ClassVar[List[str]] = ["model", "is_embedding_model", "tensor_parallel_size", "pipeline_parallel_size", "block_size", "swap_space", "gpu_mem_util", "max_num_seqs", "offloading_num", "use_prefix_caching", "use_chunked_prefill", "chunked_prefill_size", "eager_execution", "num_scheduler_steps", "use_flashinfer", "max_model_len", "dtype", "tokenizer", "spec_proposer", "spec_draft_model", "spec_tokens", "spec_prompt_lookup_min", "spec_prompt_lookup_max", "seed"]

    @field_validator('block_size')
    def block_size_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([16, 32]):
            raise ValueError("must be one of enum values (16, 32)")
        return value

    @field_validator('dtype')
    def dtype_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['auto', 'float16', 'float32', 'bfloat16']):
            raise ValueError("must be one of enum values ('auto', 'float16', 'float32', 'bfloat16')")
        return value

    @field_validator('spec_proposer')
    def spec_proposer_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['draft', 'prompt_lookup']):
            raise ValueError("must be one of enum values ('draft', 'prompt_lookup')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CServeRecipe from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if use_prefix_caching (nullable) is None
        # and model_fields_set contains the field
        if self.use_prefix_caching is None and "use_prefix_caching" in self.model_fields_set:
            _dict['use_prefix_caching'] = None

        # set to None if use_chunked_prefill (nullable) is None
        # and model_fields_set contains the field
        if self.use_chunked_prefill is None and "use_chunked_prefill" in self.model_fields_set:
            _dict['use_chunked_prefill'] = None

        # set to None if chunked_prefill_size (nullable) is None
        # and model_fields_set contains the field
        if self.chunked_prefill_size is None and "chunked_prefill_size" in self.model_fields_set:
            _dict['chunked_prefill_size'] = None

        # set to None if eager_execution (nullable) is None
        # and model_fields_set contains the field
        if self.eager_execution is None and "eager_execution" in self.model_fields_set:
            _dict['eager_execution'] = None

        # set to None if num_scheduler_steps (nullable) is None
        # and model_fields_set contains the field
        if self.num_scheduler_steps is None and "num_scheduler_steps" in self.model_fields_set:
            _dict['num_scheduler_steps'] = None

        # set to None if max_model_len (nullable) is None
        # and model_fields_set contains the field
        if self.max_model_len is None and "max_model_len" in self.model_fields_set:
            _dict['max_model_len'] = None

        # set to None if tokenizer (nullable) is None
        # and model_fields_set contains the field
        if self.tokenizer is None and "tokenizer" in self.model_fields_set:
            _dict['tokenizer'] = None

        # set to None if spec_proposer (nullable) is None
        # and model_fields_set contains the field
        if self.spec_proposer is None and "spec_proposer" in self.model_fields_set:
            _dict['spec_proposer'] = None

        # set to None if spec_draft_model (nullable) is None
        # and model_fields_set contains the field
        if self.spec_draft_model is None and "spec_draft_model" in self.model_fields_set:
            _dict['spec_draft_model'] = None

        # set to None if spec_tokens (nullable) is None
        # and model_fields_set contains the field
        if self.spec_tokens is None and "spec_tokens" in self.model_fields_set:
            _dict['spec_tokens'] = None

        # set to None if spec_prompt_lookup_min (nullable) is None
        # and model_fields_set contains the field
        if self.spec_prompt_lookup_min is None and "spec_prompt_lookup_min" in self.model_fields_set:
            _dict['spec_prompt_lookup_min'] = None

        # set to None if spec_prompt_lookup_max (nullable) is None
        # and model_fields_set contains the field
        if self.spec_prompt_lookup_max is None and "spec_prompt_lookup_max" in self.model_fields_set:
            _dict['spec_prompt_lookup_max'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CServeRecipe from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "model": obj.get("model"),
            "is_embedding_model": obj.get("is_embedding_model") if obj.get("is_embedding_model") is not None else False,
            "tensor_parallel_size": obj.get("tensor_parallel_size"),
            "pipeline_parallel_size": obj.get("pipeline_parallel_size"),
            "block_size": obj.get("block_size") if obj.get("block_size") is not None else 32,
            "swap_space": obj.get("swap_space") if obj.get("swap_space") is not None else 0,
            "gpu_mem_util": obj.get("gpu_mem_util") if obj.get("gpu_mem_util") is not None else 0.95,
            "max_num_seqs": obj.get("max_num_seqs") if obj.get("max_num_seqs") is not None else 256,
            "offloading_num": obj.get("offloading_num") if obj.get("offloading_num") is not None else 0,
            "use_prefix_caching": obj.get("use_prefix_caching"),
            "use_chunked_prefill": obj.get("use_chunked_prefill"),
            "chunked_prefill_size": obj.get("chunked_prefill_size"),
            "eager_execution": obj.get("eager_execution"),
            "num_scheduler_steps": obj.get("num_scheduler_steps"),
            "use_flashinfer": obj.get("use_flashinfer") if obj.get("use_flashinfer") is not None else False,
            "max_model_len": obj.get("max_model_len"),
            "dtype": obj.get("dtype") if obj.get("dtype") is not None else 'auto',
            "tokenizer": obj.get("tokenizer"),
            "spec_proposer": obj.get("spec_proposer"),
            "spec_draft_model": obj.get("spec_draft_model"),
            "spec_tokens": obj.get("spec_tokens"),
            "spec_prompt_lookup_min": obj.get("spec_prompt_lookup_min"),
            "spec_prompt_lookup_max": obj.get("spec_prompt_lookup_max"),
            "seed": obj.get("seed") if obj.get("seed") is not None else 0
        })
        return _obj


