# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from platform_api_python_client.models.c_serve_v2_recipe import CServeV2Recipe
from typing import Optional, Set
from typing_extensions import Self

class CreateRagDeploymentRequest(BaseModel):
    """
    CreateRagDeploymentRequest
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=20)]
    cluster_id: StrictInt
    hardware_instance_id: StrictInt
    recipe: CServeV2Recipe
    hf_token: Optional[StrictStr] = None
    llm_model: StrictStr
    centml_api_key: StrictStr
    min_scale: Optional[StrictInt] = 1
    max_scale: Optional[StrictInt] = 1
    initial_scale: Optional[StrictInt] = None
    endpoint_bearer_token: Optional[StrictStr] = None
    endpoint_certificate_authority: Optional[StrictStr] = None
    concurrency: Optional[StrictInt] = None
    env_vars: Optional[Dict[str, StrictStr]] = None
    __properties: ClassVar[List[str]] = ["name", "cluster_id", "hardware_instance_id", "recipe", "hf_token", "llm_model", "centml_api_key", "min_scale", "max_scale", "initial_scale", "endpoint_bearer_token", "endpoint_certificate_authority", "concurrency", "env_vars"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[a-z][a-z0-9-]*$", value):
            raise ValueError(r"must validate the regular expression /^[a-z][a-z0-9-]*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateRagDeploymentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of recipe
        if self.recipe:
            _dict['recipe'] = self.recipe.to_dict()
        # set to None if hf_token (nullable) is None
        # and model_fields_set contains the field
        if self.hf_token is None and "hf_token" in self.model_fields_set:
            _dict['hf_token'] = None

        # set to None if initial_scale (nullable) is None
        # and model_fields_set contains the field
        if self.initial_scale is None and "initial_scale" in self.model_fields_set:
            _dict['initial_scale'] = None

        # set to None if endpoint_bearer_token (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_bearer_token is None and "endpoint_bearer_token" in self.model_fields_set:
            _dict['endpoint_bearer_token'] = None

        # set to None if endpoint_certificate_authority (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_certificate_authority is None and "endpoint_certificate_authority" in self.model_fields_set:
            _dict['endpoint_certificate_authority'] = None

        # set to None if concurrency (nullable) is None
        # and model_fields_set contains the field
        if self.concurrency is None and "concurrency" in self.model_fields_set:
            _dict['concurrency'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateRagDeploymentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "cluster_id": obj.get("cluster_id"),
            "hardware_instance_id": obj.get("hardware_instance_id"),
            "recipe": CServeV2Recipe.from_dict(obj["recipe"]) if obj.get("recipe") is not None else None,
            "hf_token": obj.get("hf_token"),
            "llm_model": obj.get("llm_model"),
            "centml_api_key": obj.get("centml_api_key"),
            "min_scale": obj.get("min_scale") if obj.get("min_scale") is not None else 1,
            "max_scale": obj.get("max_scale") if obj.get("max_scale") is not None else 1,
            "initial_scale": obj.get("initial_scale"),
            "endpoint_bearer_token": obj.get("endpoint_bearer_token"),
            "endpoint_certificate_authority": obj.get("endpoint_certificate_authority"),
            "concurrency": obj.get("concurrency"),
            "env_vars": obj.get("env_vars")
        })
        return _obj


