# platform-api-python-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 4.0.12
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/centml/platform/client.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/centml/platform/client.git`)

Then import the package:
```python
import platform_api_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import platform_api_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import platform_api_python_client
from platform_api_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = platform_api_python_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: HTTPBearer
configuration = platform_api_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with platform_api_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = platform_api_python_client.EXTERNALApi(api_client)
    api_key_request = platform_api_python_client.APIKeyRequest() # APIKeyRequest | 

    try:
        # Create Api Key
        api_response = api_instance.create_api_key_credentials_api_key_post(api_key_request)
        print("The response of EXTERNALApi->create_api_key_credentials_api_key_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling EXTERNALApi->create_api_key_credentials_api_key_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*EXTERNALApi* | [**create_api_key_credentials_api_key_post**](docs/EXTERNALApi.md#create_api_key_credentials_api_key_post) | **POST** /credentials/api-key | Create Api Key
*EXTERNALApi* | [**create_checkout_payments_checkout_post**](docs/EXTERNALApi.md#create_checkout_payments_checkout_post) | **POST** /payments/checkout | Create Checkout
*EXTERNALApi* | [**create_compute_deployment_deployments_compute_post**](docs/EXTERNALApi.md#create_compute_deployment_deployments_compute_post) | **POST** /deployments/compute | Create Compute Deployment
*EXTERNALApi* | [**create_cserve_v2_deployment_deployments_cserve_v2_post**](docs/EXTERNALApi.md#create_cserve_v2_deployment_deployments_cserve_v2_post) | **POST** /deployments/cserve_v2 | Create Cserve V2 Deployment
*EXTERNALApi* | [**create_inference_deployment_deployments_inference_post**](docs/EXTERNALApi.md#create_inference_deployment_deployments_inference_post) | **POST** /deployments/inference | Create Inference Deployment
*EXTERNALApi* | [**create_rag_deployment_deployments_rag_post**](docs/EXTERNALApi.md#create_rag_deployment_deployments_rag_post) | **POST** /deployments/rag | Create Rag Deployment
*EXTERNALApi* | [**create_setup_payments_setup_checkout_post**](docs/EXTERNALApi.md#create_setup_payments_setup_checkout_post) | **POST** /payments/setup_checkout | Create Setup
*EXTERNALApi* | [**create_support_ticket_support_post**](docs/EXTERNALApi.md#create_support_ticket_support_post) | **POST** /support | Create Support Ticket
*EXTERNALApi* | [**delete_api_key_credentials_api_key_id_delete**](docs/EXTERNALApi.md#delete_api_key_credentials_api_key_id_delete) | **DELETE** /credentials/api-key/{id} | Delete Api Key
*EXTERNALApi* | [**delete_autocharge_preferences_autocharge_preferences_delete**](docs/EXTERNALApi.md#delete_autocharge_preferences_autocharge_preferences_delete) | **DELETE** /autocharge/preferences | Delete Autocharge Preferences
*EXTERNALApi* | [**delete_payment_method_payments_methods_delete**](docs/EXTERNALApi.md#delete_payment_method_payments_methods_delete) | **DELETE** /payments/methods | Delete Payment Method
*EXTERNALApi* | [**delete_user_vault_item_endpoint_user_vault_delete**](docs/EXTERNALApi.md#delete_user_vault_item_endpoint_user_vault_delete) | **DELETE** /user_vault | Delete User Vault Item Endpoint
*EXTERNALApi* | [**download_url_file_url_download_post**](docs/EXTERNALApi.md#download_url_file_url_download_post) | **POST** /file_url/download | Download Url
*EXTERNALApi* | [**get_all_user_vault_items_endpoint_user_vault_get**](docs/EXTERNALApi.md#get_all_user_vault_items_endpoint_user_vault_get) | **GET** /user_vault | Get All User Vault Items Endpoint
*EXTERNALApi* | [**get_api_keys_credentials_api_key_get**](docs/EXTERNALApi.md#get_api_keys_credentials_api_key_get) | **GET** /credentials/api-key | Get Api Keys
*EXTERNALApi* | [**get_autocharge_preferences_autocharge_preferences_get**](docs/EXTERNALApi.md#get_autocharge_preferences_autocharge_preferences_get) | **GET** /autocharge/preferences | Get Autocharge Preferences
*EXTERNALApi* | [**get_clusters_clusters_get**](docs/EXTERNALApi.md#get_clusters_clusters_get) | **GET** /clusters | Get Clusters
*EXTERNALApi* | [**get_compute_deployment_deployments_compute_deployment_id_get**](docs/EXTERNALApi.md#get_compute_deployment_deployments_compute_deployment_id_get) | **GET** /deployments/compute/{deployment_id} | Get Compute Deployment
*EXTERNALApi* | [**get_credits_credits_get**](docs/EXTERNALApi.md#get_credits_credits_get) | **GET** /credits | Get Credits
*EXTERNALApi* | [**get_cserve_recipe_deployments_cserve_recipes_get**](docs/EXTERNALApi.md#get_cserve_recipe_deployments_cserve_recipes_get) | **GET** /deployments/cserve/recipes | Get Cserve Recipe
*EXTERNALApi* | [**get_cserve_v2_deployment_deployments_cserve_v2_deployment_id_get**](docs/EXTERNALApi.md#get_cserve_v2_deployment_deployments_cserve_v2_deployment_id_get) | **GET** /deployments/cserve_v2/{deployment_id} | Get Cserve V2 Deployment
*EXTERNALApi* | [**get_deployment_logs_deployments_logs_deployment_id_get**](docs/EXTERNALApi.md#get_deployment_logs_deployments_logs_deployment_id_get) | **GET** /deployments/logs/{deployment_id} | Get Deployment Logs
*EXTERNALApi* | [**get_deployment_status_deployments_status_deployment_id_get**](docs/EXTERNALApi.md#get_deployment_status_deployments_status_deployment_id_get) | **GET** /deployments/status/{deployment_id} | Get Deployment Status
*EXTERNALApi* | [**get_deployments_deployments_get**](docs/EXTERNALApi.md#get_deployments_deployments_get) | **GET** /deployments | Get Deployments
*EXTERNALApi* | [**get_hardware_instances_hardware_instances_get**](docs/EXTERNALApi.md#get_hardware_instances_hardware_instances_get) | **GET** /hardware-instances | Get Hardware Instances
*EXTERNALApi* | [**get_inference_deployment_deployments_inference_deployment_id_get**](docs/EXTERNALApi.md#get_inference_deployment_deployments_inference_deployment_id_get) | **GET** /deployments/inference/{deployment_id} | Get Inference Deployment
*EXTERNALApi* | [**get_payment_method_payments_methods_get**](docs/EXTERNALApi.md#get_payment_method_payments_methods_get) | **GET** /payments/methods | Get Payment Method
*EXTERNALApi* | [**get_payments_payments_get**](docs/EXTERNALApi.md#get_payments_payments_get) | **GET** /payments | Get Payments
*EXTERNALApi* | [**get_prebuilt_images_prebuilt_images_get**](docs/EXTERNALApi.md#get_prebuilt_images_prebuilt_images_get) | **GET** /prebuilt-images | Get Prebuilt Images
*EXTERNALApi* | [**get_rag_deployment_deployments_rag_deployment_id_get**](docs/EXTERNALApi.md#get_rag_deployment_deployments_rag_deployment_id_get) | **GET** /deployments/rag/{deployment_id} | Get Rag Deployment
*EXTERNALApi* | [**get_usage_daily_bills_get**](docs/EXTERNALApi.md#get_usage_daily_bills_get) | **GET** /daily_bills | Get Usage
*EXTERNALApi* | [**get_usage_deployments_usage_deployment_id_get**](docs/EXTERNALApi.md#get_usage_deployments_usage_deployment_id_get) | **GET** /deployments/usage/{deployment_id} | Get Usage
*EXTERNALApi* | [**setup_stripe_customer_payments_setup_post**](docs/EXTERNALApi.md#setup_stripe_customer_payments_setup_post) | **POST** /payments/setup | Setup Stripe Customer
*EXTERNALApi* | [**update_autocharge_preferences_autocharge_preferences_put**](docs/EXTERNALApi.md#update_autocharge_preferences_autocharge_preferences_put) | **PUT** /autocharge/preferences | Update Autocharge Preferences
*EXTERNALApi* | [**update_compute_deployment_deployments_compute_put**](docs/EXTERNALApi.md#update_compute_deployment_deployments_compute_put) | **PUT** /deployments/compute | Update Compute Deployment
*EXTERNALApi* | [**update_cserve_v2_deployment_deployments_cserve_v2_put**](docs/EXTERNALApi.md#update_cserve_v2_deployment_deployments_cserve_v2_put) | **PUT** /deployments/cserve_v2 | Update Cserve V2 Deployment
*EXTERNALApi* | [**update_deployment_status_deployments_status_deployment_id_put**](docs/EXTERNALApi.md#update_deployment_status_deployments_status_deployment_id_put) | **PUT** /deployments/status/{deployment_id} | Update Deployment Status
*EXTERNALApi* | [**update_inference_deployment_deployments_inference_put**](docs/EXTERNALApi.md#update_inference_deployment_deployments_inference_put) | **PUT** /deployments/inference | Update Inference Deployment
*EXTERNALApi* | [**update_rag_deployment_deployments_rag_put**](docs/EXTERNALApi.md#update_rag_deployment_deployments_rag_put) | **PUT** /deployments/rag | Update Rag Deployment
*EXTERNALApi* | [**update_user_vault_item_endpoint_user_vault_put**](docs/EXTERNALApi.md#update_user_vault_item_endpoint_user_vault_put) | **PUT** /user_vault | Update User Vault Item Endpoint
*EXTERNALApi* | [**upload_url_file_url_upload_post**](docs/EXTERNALApi.md#upload_url_file_url_upload_post) | **POST** /file_url/upload | Upload Url


## Documentation For Models

 - [APIKeyRequest](docs/APIKeyRequest.md)
 - [APIKeyResponse](docs/APIKeyResponse.md)
 - [CServeRecipePerf](docs/CServeRecipePerf.md)
 - [CServeRecipeResponse](docs/CServeRecipeResponse.md)
 - [CServeV2Recipe](docs/CServeV2Recipe.md)
 - [CreateCServeV2DeploymentRequest](docs/CreateCServeV2DeploymentRequest.md)
 - [CreateCServeV2DeploymentResponse](docs/CreateCServeV2DeploymentResponse.md)
 - [CreateCheckoutRequest](docs/CreateCheckoutRequest.md)
 - [CreateCheckoutSessionResponse](docs/CreateCheckoutSessionResponse.md)
 - [CreateComputeDeploymentRequest](docs/CreateComputeDeploymentRequest.md)
 - [CreateComputeDeploymentResponse](docs/CreateComputeDeploymentResponse.md)
 - [CreateInferenceDeploymentRequest](docs/CreateInferenceDeploymentRequest.md)
 - [CreateInferenceDeploymentResponse](docs/CreateInferenceDeploymentResponse.md)
 - [CreateRagDeploymentRequest](docs/CreateRagDeploymentRequest.md)
 - [CreateRagDeploymentResponse](docs/CreateRagDeploymentResponse.md)
 - [CreateSetupCheckoutRequest](docs/CreateSetupCheckoutRequest.md)
 - [CreateUrlRequest](docs/CreateUrlRequest.md)
 - [CreateUrlResponse](docs/CreateUrlResponse.md)
 - [CreditsResponse](docs/CreditsResponse.md)
 - [DailyBillResponse](docs/DailyBillResponse.md)
 - [DeploymentStatus](docs/DeploymentStatus.md)
 - [DeploymentStatusRequest](docs/DeploymentStatusRequest.md)
 - [DeploymentStatusResponse](docs/DeploymentStatusResponse.md)
 - [DeploymentType](docs/DeploymentType.md)
 - [DeploymentUsage](docs/DeploymentUsage.md)
 - [DeploymentUsageValue](docs/DeploymentUsageValue.md)
 - [GetAutochargePreferencesResponse](docs/GetAutochargePreferencesResponse.md)
 - [GetCServeV2DeploymentResponse](docs/GetCServeV2DeploymentResponse.md)
 - [GetClusterResponse](docs/GetClusterResponse.md)
 - [GetComputeDeploymentResponse](docs/GetComputeDeploymentResponse.md)
 - [GetDeploymentLogResponse](docs/GetDeploymentLogResponse.md)
 - [GetDeploymentResponse](docs/GetDeploymentResponse.md)
 - [GetDeploymentUsageResponse](docs/GetDeploymentUsageResponse.md)
 - [GetInferenceDeploymentResponse](docs/GetInferenceDeploymentResponse.md)
 - [GetPaymentResponse](docs/GetPaymentResponse.md)
 - [GetRagDeploymentResponse](docs/GetRagDeploymentResponse.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HardwareInstanceResponse](docs/HardwareInstanceResponse.md)
 - [ListAPIKeyResponse](docs/ListAPIKeyResponse.md)
 - [ListCServeRecipeResponse](docs/ListCServeRecipeResponse.md)
 - [ListDailyBillResponse](docs/ListDailyBillResponse.md)
 - [ListGetClusterResponse](docs/ListGetClusterResponse.md)
 - [ListGetDeploymentResponse](docs/ListGetDeploymentResponse.md)
 - [ListHardwareInstanceResponse](docs/ListHardwareInstanceResponse.md)
 - [ListPaymentsResponse](docs/ListPaymentsResponse.md)
 - [ListPrebuiltImageResponse](docs/ListPrebuiltImageResponse.md)
 - [ListUserVaultItemsResponse](docs/ListUserVaultItemsResponse.md)
 - [Metric](docs/Metric.md)
 - [PaymentMethodResponse](docs/PaymentMethodResponse.md)
 - [PodStatus](docs/PodStatus.md)
 - [PrebuiltImageResponse](docs/PrebuiltImageResponse.md)
 - [ServiceStatus](docs/ServiceStatus.md)
 - [SetupUserResponse](docs/SetupUserResponse.md)
 - [TicketCategory](docs/TicketCategory.md)
 - [TicketPriority](docs/TicketPriority.md)
 - [UpdateAutochargePreferencesRequest](docs/UpdateAutochargePreferencesRequest.md)
 - [UpdateDeploymentResponse](docs/UpdateDeploymentResponse.md)
 - [UserVaultItem](docs/UserVaultItem.md)
 - [UserVaultType](docs/UserVaultType.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication


## Author




