# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from platform_api_python_client.models.pod_details import PodDetails
from platform_api_python_client.models.service_status import ServiceStatus
from typing import Optional, Set
from typing_extensions import Self

class RevisionPodDetails(BaseModel):
    """
    RevisionPodDetails
    """ # noqa: E501
    revision_number: Optional[StrictInt] = None
    revision_status: ServiceStatus
    pod_details_list: Optional[List[PodDetails]] = None
    error_message: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["revision_number", "revision_status", "pod_details_list", "error_message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RevisionPodDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in pod_details_list (list)
        _items = []
        if self.pod_details_list:
            for _item_pod_details_list in self.pod_details_list:
                if _item_pod_details_list:
                    _items.append(_item_pod_details_list.to_dict())
            _dict['pod_details_list'] = _items
        # set to None if revision_number (nullable) is None
        # and model_fields_set contains the field
        if self.revision_number is None and "revision_number" in self.model_fields_set:
            _dict['revision_number'] = None

        # set to None if pod_details_list (nullable) is None
        # and model_fields_set contains the field
        if self.pod_details_list is None and "pod_details_list" in self.model_fields_set:
            _dict['pod_details_list'] = None

        # set to None if error_message (nullable) is None
        # and model_fields_set contains the field
        if self.error_message is None and "error_message" in self.model_fields_set:
            _dict['error_message'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RevisionPodDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "revision_number": obj.get("revision_number"),
            "revision_status": obj.get("revision_status"),
            "pod_details_list": [PodDetails.from_dict(_item) for _item in obj["pod_details_list"]] if obj.get("pod_details_list") is not None else None,
            "error_message": obj.get("error_message")
        })
        return _obj


