# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from platform_api_python_client.models.deployment_status import DeploymentStatus
from platform_api_python_client.models.deployment_type import DeploymentType
from platform_api_python_client.models.revision_pod_details import RevisionPodDetails
from platform_api_python_client.models.rollout_status import RolloutStatus
from typing import Optional, Set
from typing_extensions import Self

class DeploymentStatusV3Response(BaseModel):
    """
    DeploymentStatusV3Response
    """ # noqa: E501
    id: StrictInt
    type: DeploymentType
    status: DeploymentStatus
    rollout_status: Optional[RolloutStatus] = None
    endpoint_url: Optional[StrictStr] = None
    revision_pod_details_list: Optional[List[RevisionPodDetails]] = None
    __properties: ClassVar[List[str]] = ["id", "type", "status", "rollout_status", "endpoint_url", "revision_pod_details_list"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeploymentStatusV3Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in revision_pod_details_list (list)
        _items = []
        if self.revision_pod_details_list:
            for _item_revision_pod_details_list in self.revision_pod_details_list:
                if _item_revision_pod_details_list:
                    _items.append(_item_revision_pod_details_list.to_dict())
            _dict['revision_pod_details_list'] = _items
        # set to None if rollout_status (nullable) is None
        # and model_fields_set contains the field
        if self.rollout_status is None and "rollout_status" in self.model_fields_set:
            _dict['rollout_status'] = None

        # set to None if endpoint_url (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_url is None and "endpoint_url" in self.model_fields_set:
            _dict['endpoint_url'] = None

        # set to None if revision_pod_details_list (nullable) is None
        # and model_fields_set contains the field
        if self.revision_pod_details_list is None and "revision_pod_details_list" in self.model_fields_set:
            _dict['revision_pod_details_list'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeploymentStatusV3Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "rollout_status": obj.get("rollout_status"),
            "endpoint_url": obj.get("endpoint_url"),
            "revision_pod_details_list": [RevisionPodDetails.from_dict(_item) for _item in obj["revision_pod_details_list"]] if obj.get("revision_pod_details_list") is not None else None
        })
        return _obj


