# coding: utf-8

"""
    Platform External API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from platform_api_python_client.models.deployment_status import DeploymentStatus
from platform_api_python_client.models.deployment_type import DeploymentType
from platform_api_python_client.models.image_pull_secret_credentials import ImagePullSecretCredentials
from typing import Optional, Set
from typing_extensions import Self

class GetInferenceV3DeploymentResponse(BaseModel):
    """
    GetInferenceV3DeploymentResponse
    """ # noqa: E501
    creator_email: StrictStr
    cluster_id: StrictInt
    id: StrictInt
    name: StrictStr
    endpoint_url: StrictStr
    image_url: Optional[StrictStr] = None
    type: DeploymentType
    status: DeploymentStatus
    created_at: datetime
    hardware_instance_id: StrictInt
    revision_number: StrictInt
    container_port: StrictInt
    min_replicas: StrictInt
    max_replicas: StrictInt
    initial_replicas: Optional[StrictInt] = None
    concurrency: Optional[StrictInt] = None
    healthcheck: Optional[StrictStr] = None
    endpoint_certificate_authority: Optional[StrictStr] = None
    endpoint_bearer_token: Optional[StrictStr] = None
    env_vars: Optional[Dict[str, StrictStr]] = None
    command: Optional[List[StrictStr]] = None
    command_args: Optional[List[StrictStr]] = None
    image_pull_secret_credentials: Optional[ImagePullSecretCredentials] = None
    __properties: ClassVar[List[str]] = ["creator_email", "cluster_id", "id", "name", "endpoint_url", "image_url", "type", "status", "created_at", "hardware_instance_id", "revision_number", "container_port", "min_replicas", "max_replicas", "initial_replicas", "concurrency", "healthcheck", "endpoint_certificate_authority", "endpoint_bearer_token", "env_vars", "command", "command_args", "image_pull_secret_credentials"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetInferenceV3DeploymentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image_pull_secret_credentials
        if self.image_pull_secret_credentials:
            _dict['image_pull_secret_credentials'] = self.image_pull_secret_credentials.to_dict()
        # set to None if image_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_url is None and "image_url" in self.model_fields_set:
            _dict['image_url'] = None

        # set to None if initial_replicas (nullable) is None
        # and model_fields_set contains the field
        if self.initial_replicas is None and "initial_replicas" in self.model_fields_set:
            _dict['initial_replicas'] = None

        # set to None if concurrency (nullable) is None
        # and model_fields_set contains the field
        if self.concurrency is None and "concurrency" in self.model_fields_set:
            _dict['concurrency'] = None

        # set to None if healthcheck (nullable) is None
        # and model_fields_set contains the field
        if self.healthcheck is None and "healthcheck" in self.model_fields_set:
            _dict['healthcheck'] = None

        # set to None if endpoint_certificate_authority (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_certificate_authority is None and "endpoint_certificate_authority" in self.model_fields_set:
            _dict['endpoint_certificate_authority'] = None

        # set to None if endpoint_bearer_token (nullable) is None
        # and model_fields_set contains the field
        if self.endpoint_bearer_token is None and "endpoint_bearer_token" in self.model_fields_set:
            _dict['endpoint_bearer_token'] = None

        # set to None if env_vars (nullable) is None
        # and model_fields_set contains the field
        if self.env_vars is None and "env_vars" in self.model_fields_set:
            _dict['env_vars'] = None

        # set to None if command (nullable) is None
        # and model_fields_set contains the field
        if self.command is None and "command" in self.model_fields_set:
            _dict['command'] = None

        # set to None if command_args (nullable) is None
        # and model_fields_set contains the field
        if self.command_args is None and "command_args" in self.model_fields_set:
            _dict['command_args'] = None

        # set to None if image_pull_secret_credentials (nullable) is None
        # and model_fields_set contains the field
        if self.image_pull_secret_credentials is None and "image_pull_secret_credentials" in self.model_fields_set:
            _dict['image_pull_secret_credentials'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetInferenceV3DeploymentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "creator_email": obj.get("creator_email"),
            "cluster_id": obj.get("cluster_id"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "endpoint_url": obj.get("endpoint_url"),
            "image_url": obj.get("image_url"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "hardware_instance_id": obj.get("hardware_instance_id"),
            "revision_number": obj.get("revision_number"),
            "container_port": obj.get("container_port"),
            "min_replicas": obj.get("min_replicas"),
            "max_replicas": obj.get("max_replicas"),
            "initial_replicas": obj.get("initial_replicas"),
            "concurrency": obj.get("concurrency"),
            "healthcheck": obj.get("healthcheck"),
            "endpoint_certificate_authority": obj.get("endpoint_certificate_authority"),
            "endpoint_bearer_token": obj.get("endpoint_bearer_token"),
            "env_vars": obj.get("env_vars"),
            "command": obj.get("command"),
            "command_args": obj.get("command_args"),
            "image_pull_secret_credentials": ImagePullSecretCredentials.from_dict(obj["image_pull_secret_credentials"]) if obj.get("image_pull_secret_credentials") is not None else None
        })
        return _obj


