# Plot2LLM Examples and Validation Results

This directory contains all examples, test outputs, and validation results for the Plot2LLM library.

## Directory Structure

### 📁 examples/
- **seaborn/**: Seaborn-specific examples and outputs
- **advanced/**: Advanced usage examples
- **validation/**: Validation test results

### 📁 tests/
- **outputs/**: Test output files (JSON and images)
- **debug/**: Debug files and intermediate results

### 📁 validation/
- **results/**: Validation result files
- **images/**: Generated validation images

### 📁 docs/
- **screenshots/**: Documentation screenshots

## File Types

- **.json**: Analysis results in JSON format
- **.png**: Generated plot images
- **.txt**: Log files and text outputs

## Usage

These files are generated automatically when running:
- `python example_seaborn.py`
- `python test_improvements.py`
- `python debug_heatmap_detection.py`
- Other example and test scripts

## Note

This directory is excluded from the main repository via .gitignore to keep the repository clean.
