
<h1 align="center">
  <br>
  <a href="https://plotapi.com"><img src="https://plotapi.com/wp-content/uploads/2021/07/plotapi_logo.svg" alt="Plotapi" width="300"></a>
</h1>

<h4 align="center">Engaging visualisations, made easy.</h4>

<center>

[![](https://img.shields.io/badge/pypi%20package-1.0-success.svg)](https://pypi.org/project/plotapi/)
[![](https://img.shields.io/badge/license-get-green.svg)](https://plotapi.com)
[![](https://img.shields.io/badge/chat-join-7289da.svg)](https://discord.gg/nsezsyb)
[![](https://img.shields.io/badge/supports-jupyter-orange.svg)](https://jupyter.org)
[![](https://img.shields.io/badge/linked-in-blue.svg)](https://www.linkedin.com/in/shahinrostami/)

</center>

</p>

<p align="center">
  <a href="#key-features">Key Features</a> •
    <a href="#get-access">Get Access</a> •
  <a href="#installation">Installation</a> •
  <a href="#getting-started">Usage</a> •
  <a href="#license">License</a>
</p>

![screenshot](https://camo.githubusercontent.com/bc1ec6f2bb8ce41fad9e16ea35a0d12da8bbacb77051504361978a6abd7c4a16/68747470733a2f2f6e6577736c65747465722e64617461637261796f6e2e636f6d2f75706c6f6164732f61635f6475636b735f322e706e67)

## Key Features

* **Chord Pro** - Illustrate inter-relationships between data.
* **Sankey Pro** - Illustrate the flow from one set of values to another.
* **Distribution Pro** - Illustrate sharing something out amongst recipients.
* **Confusion Matrix Pro** - Illustrate classifier performance interactively.
* **Upcoming Visualisations** - Access to new visualisations as they are introduced.
* **Supports Most Programming Languages** - Get started with any language able to make HTTP requests.
* **First-Class Python Support** - Get started with pip install plotapi
* **Jupyter Lab Support** - Super-charge your notebooks with inline visualisations.
* **Beautiful Themes & Fonts** - Select from pre-made beautiful themes, or add your own.
* **Share or Embed Interactive HTML** - Download and embed your interactive visualisations.
* **Render to PDF, SVG, or PNG** - Generate high-quality output ready for print.
* **Record Animation to Video** -Create social media-ready animated visualisations.

## Get Access

Visit [the website](https://plotapi.com/#pricing) to get access to Plotapi.

## Installation

Get up and running with Python with the following command.

```bash
pip install plotapi
```

## Usage

### Prepare your data.

```python
matrix = [
    [0, 5, 6, 4, 7, 4],
    [5, 0, 5, 4, 6, 5],
    [6, 5, 0, 4, 5, 5],
    [4, 4, 4, 0, 5, 5],
    [7, 6, 5, 5, 0, 4],
    [4, 5, 5, 5, 4, 0],
]

names = ["Action", "Adventure", "Comedy", "Drama", "Fantasy", "Thriller"]
```

### Plotapi - Chord Pro

```python
Chord(matrix, names)
```


## License

MIT

---

> [plotapi.com](https://www.plotapi.com) &nbsp;&middot;&nbsp;
> GitHub [@shahinrostami](https://github.com/shahinrostami) &nbsp;&middot;&nbsp;
> Twitter [@shahinrostami](https://twitter.com/shahinrostami)

