import copy
import warnings

import pandas as pd

warnings.simplefilter("ignore", UserWarning)

from dash import Dash, dcc, html, Input, Output, State, ALL
from .components import *
import dash_dangerously_set_inner_html
import os


class Plot:

    filter_list = []
    add_filter_btn_count = 0
    main_chart_btn_clicks = 0
    stra_alys_chart_btn_clicks = 0

    save_clicks = 0
    line_selected = -1
    btn_list = (0, 1, 2, 3, 4, 5, 6, 7, 8, 9)
    select_all_status = False


    def __new__(self, backtest_result_df, number_of_curves):

        self.chart_bg   = '#1f2c56'
        self.init_chart = True
        self.chart_type = 'main_chart'
        self.graph_df = pd.DataFrame()
        self.save_btn_str = ''

        self.backtest_result_df = backtest_result_df
        self.backtest_result_dict  = self.backtest_result_df.to_dict(orient='index')
        self.backtest_result_key   = list(self.backtest_result_dict.keys())

        self.start_date          = self.backtest_result_dict[self.backtest_result_key[0]]['start_date']
        self.end_date            = self.backtest_result_dict[self.backtest_result_key[0]]['end_date']
        self.backtest_name       = self.backtest_result_dict[self.backtest_result_key[0]]['backtest_name']
        self.intraday            = self.backtest_result_dict[self.backtest_result_key[0]]['intraday']
        self.freq                = self.backtest_result_dict[self.backtest_result_key[0]]['freq']
        self.risk_free_rate      = self.backtest_result_dict[self.backtest_result_key[0]]['risk_free_rate']
        self.initial_capital     = self.backtest_result_dict[self.backtest_result_key[0]]['initial_capital']
        self.data_folder         = self.backtest_result_dict[self.backtest_result_key[0]]['data_folder']
        self.equity_curve_folder = self.backtest_result_dict[self.backtest_result_key[0]]['equity_curve_folder']

        para_keys_str            = self.backtest_result_dict[self.backtest_result_key[0]]['para_keys_str']
        self.para_keys_list = para_keys_str.split('|')

        components = Components(number_of_curves)

        self.start_year = datetime.datetime.strptime(self.start_date, '%Y-%m-%d').year
        self.end_year   = datetime.datetime.strptime(self.end_date, '%Y-%m-%d').year
        self.year_list  = list(range(self.start_year, self.end_year + 1))

        empty_line_chart = components.empty_line_chart()

        checkbox_div, code_list = components.update_checkbox_div(self.para_keys_list, self.backtest_result_df)

        performance_matrix = components.update_performance_matrix(self.init_chart,
                                                                  self.para_keys_list,
                                                                  self.backtest_result_df.iloc[[0]].copy()
                                                                  )

        filter_div = components.update_filter_div([])


        sort_method_dropdown      = components.sort_method_dropdown
        filter_dropdown           = components.filter_dropdown
        filter_dropdown_disabled  = components.filter_dropdown_disabled
        filter_input              = components.filter_input
        filter_input_disabled     = components.filter_input_disabled
        add_filter_save_btn_style          = components.add_filter_btn_style
        add_filter_save_btn_style_disabled = components.add_filter_btn_style_disabled

        app = Dash(__name__, external_stylesheets=[dbc.themes.SUPERHERO], suppress_callback_exceptions=True)

        my_css_data = """
                body {
                  background-color: #1a2245;
                }
                
                /* width */
                ::-webkit-scrollbar {
                  width: 10px !important;
                  display: block !important;
                }

                /* Track */
                ::-webkit-scrollbar-track {
                  background: #1f2c56 !important;
                  border-radius: 10px !important;
                  display: block !important;
                }


                /* Handle */
                ::-webkit-scrollbar-thumb {
                  background: #154360;
                  border-radius: 10px;
                }
                
                """
        innerHtmlText = "<style>%s</style>" % my_css_data

        app.layout = html.Div([

            dash_dangerously_set_inner_html.DangerouslySetInnerHTML(innerHtmlText),

            html.Div(style={'height': '10px', }),
            html.Div(
                dbc.Row([
                    # Left Column
                    dbc.Col(html.Div([
                        html.Div(style={'height': '15px', }),
                        html.Div('Sorting Method', style={'color': 'Cyan', 'margin-left': '15px', 'font-size': '15px'}),
                        html.Div(style={'height': '10px', }),
                        sort_method_dropdown,
                        html.Div(style={'height': '15px', }),
                        html.Div('Parameters', style={'color': 'Cyan', 'margin-left': '15px', 'font-size': '15px'}),
                        html.Div(id='checklist-container',children=checkbox_div),
                        html.Div(style={'height': '10px', }),
                        html.Div('Filters for', style={'color': 'Cyan', 'margin-left': '15px', 'font-size': '15px'}),
                        html.Div(style={'height': '10px', }),
                        html.Div(id='filter', children=filter_div,style={'padding': '0px 20px',
                                                                         'padding-right': '10px',
                                                                         'font-size': '12px'}),
                        dbc.Row([
                            dbc.Col(id='filter_dropdown_div',children=filter_dropdown,width=8),
                            dbc.Col(id='filter_input_div',children=filter_input,width=3),
                        ]),
                        html.Div(style={'height': '20px', }),
                        html.Div(id='add_filter_btn',children=html.Div([html.Div(style={'height': '5px'}),'Add Filter']),
                                 style=add_filter_save_btn_style),

                        #html.Div(style={'height': '25px', }),

                    ],style={'padding':'0px','border-radius':'5px','height': '704px',
                             'background-color':'rgba(0, 0, 0, 0)'})
                        ,style={'padding':'0','padding-left':'5px'}, width=2),

                    # Middle Column
                    dbc.Col(html.Div([

                        html.Div(id='performance_matrix', children=performance_matrix),

                    ], style={'padding': '5px',})
                        , style={'padding': '0', }, width=2),


                    # Right Column
                    dbc.Col(html.Div([
                        html.Div(style={'height': '5px', }),

                        html.Div(id='main_chart_area',
                            children=[html.Div(html.Img(),style={'height':'10px'}),

                                      dbc.Row([
                                          dbc.Col(html.Div(id='main_chart_btn', children='',
                                                           style={'text-align': 'left', 'cursor': 'pointer',
                                                                  'font-size': '14px'}), width=4),
                                          dbc.Col(html.Div(html.Img()), width=4),
                                          dbc.Col(html.Div(id='stra_alys_chart_btn', children=''), width=4),
                                      ], style={'margin': '0px 5px'}),
                                      html.Div(id='chart_area',
                                               children=dcc.Graph(id='line_chart', figure=empty_line_chart)),

                                      html.Div(style={'height': '10px', }),

                                     ],style={'padding':'5px','border-radius':'5px','background-color':self.chart_bg}),

                        html.Div(style={'height': '5px', }),

                    ]), style={'padding':'0'}, width=8),
                ])
            ),

        ], style={'width':'1500px','margin':'auto','padding':'0px 10px','color':'white'})


        @app.callback(
            Output('line_chart', 'figure'),
            Output('filter', 'children'),
            Output('filter_dropdown_div', 'children'),
            Output('filter_input_div', 'children'),
            Output('add_filter_btn', 'style'),
            Output('filter_input', 'value'),
            Output('main_chart_btn', 'children'),
            Output('stra_alys_chart_btn', 'children'),
            Output('main_chart_area', 'style'),
            Input('sort_method', 'value'),
            Input({'type': 'para-checklist', 'index': ALL}, 'value'),
            State('filter_dropdown_div', 'children'),
            State('filter_input_div', 'children'),
            State('line_chart', 'figure'),
            State('filter', 'children'),
            Input('add_filter_btn', 'n_clicks'),
            Input('main_chart_btn', 'n_clicks'),
            Input('stra_alys_chart_btn', 'n_clicks'),
            State('add_filter_btn', 'style'),
            State('filter_name', 'value'),
            State('filter_input', 'value'),
            State('main_chart_area', 'style'),
            [Input('btn_' + str(i), 'n_clicks') for i in range(10)],
        )
        def display_output(sort_method, para_checklist, filter_dropdown_div,filter_input_div,
                           fig_line,filter_div,add_filter_btn_clicks, main_chart_btn_clicks,stra_alys_chart_btn_clicks,
                           _add_filter_save_btn_style,filter_name,filter_input_value,\
                           main_chart_area_style, *vals):

            main_chart_btn_text        = ''
            stra_alys_chart_btn_text = ''

            main_chart_btn_click = False

            if main_chart_btn_clicks:
                if main_chart_btn_clicks > self.main_chart_btn_clicks:
                    main_chart_btn_click = True
                    self.main_chart_btn_clicks = main_chart_btn_clicks
                    self. chart_type = 'main_chart'

            if stra_alys_chart_btn_clicks:
                if stra_alys_chart_btn_clicks > self.stra_alys_chart_btn_clicks:
                    self.stra_alys_chart_btn_clicks = stra_alys_chart_btn_clicks
                    if self.chart_type == 'stra_alys_chart':
                        main_chart_btn_text = '< Back'
                        return fig_line, filter_div, filter_dropdown_div, filter_input_div, _add_filter_save_btn_style, \
                               None, main_chart_btn_text, stra_alys_chart_btn_text, main_chart_area_style
                    else:
                        if self.line_selected > -1:
                            fig_line = components.generate_stra_alys_chart(self.intraday, self.graph_df, self.line_selected,
                                                                           self.para_keys_list, self.backtest_result_dict)

                            self.chart_type = 'stra_alys_chart'
                            main_chart_btn_text = '< Back'

                            return fig_line, filter_div, filter_dropdown_div, filter_input_div, _add_filter_save_btn_style,\
                                   None, main_chart_btn_text, stra_alys_chart_btn_text, main_chart_area_style
                        else:
                            pass    # No Line Selected


            ## Initialize After Refresh
            if not self.init_chart:
                if not add_filter_btn_clicks:
                    if not main_chart_btn_click:
                        #self.sort_method_current = sort_method
                        self.filter_list = []
                        self.add_filter_btn_count = 0
                        self.stra_alys_chart_btn_clicks = 0
                        self.save_clicks = 0
                        self.chart_type = 'main_chart'
                        self.line_selected = -1
                        self.init_chart = True
                        filter_dropdown_div = filter_dropdown
                        filter_input_div = filter_input

            ######################################################################

            if add_filter_btn_clicks:
                if add_filter_btn_clicks > self.add_filter_btn_count: ## Add btn Pressed
                    self.add_filter_btn_count = add_filter_btn_clicks
                    if filter_name:
                        if filter_input_value:
                            if filter_name == 'exclude':
                                self.filter_list.append(['exclude', ' ', filter_input_value])
                            else:
                                self.filter_list.append([filter_name[0:-1], filter_name[-1], filter_input_value])
                            filter_div = components.update_filter_div(self.filter_list)
                            if len(self.filter_list) > 11:
                                filter_dropdown_div = filter_dropdown_disabled
                                filter_input_div = filter_input_disabled
                                _add_filter_save_btn_style = add_filter_save_btn_style_disabled
                            else:
                                filter_dropdown_div = filter_dropdown
                                filter_input_div = filter_input
                            self.init_chart = False

            else:
                self.add_filter_btn_count = 0  # Necessary for initialization


            # Filter delete btn pressed, remove one filter
            for i in range(len(vals)):
                if not vals[i] == self.btn_list[i]:
                    self.filter_list.pop(i)
                    filter_div = components.update_filter_div(self.filter_list)
                    filter_dropdown_div = filter_dropdown
                    filter_input_div = filter_input
                    self.add_filter_btn_count =- 1  # Necessary for add btn count
                    if len(self.filter_list) < 12:
                        filter_dropdown_div = filter_dropdown
                        filter_input_div = filter_input
                        _add_filter_save_btn_style = add_filter_save_btn_style
                    break

            ####################################################
            #### Sort Method Selected, generate main_chart #####
            ####################################################
            if sort_method:
                for para in para_checklist:
                    if para == []:
                        fig_line = components.empty_line_chart()
                        stra_alys_chart_btn_text = 'Strategy alysis >'
                        self.chart_type = 'main_chart'

                        return fig_line, filter_div, filter_dropdown_div, filter_input_div, _add_filter_save_btn_style, \
                            None, main_chart_btn_text, stra_alys_chart_btn_text, main_chart_area_style


                current_df = copy.deepcopy(backtest_result_df)
                current_df = current_df.reset_index(drop=False)

                ### Filter according to the filer list ###
                if len(self.filter_list) > 0:
                    for element in self.filter_list:
                        if element[1] == '<':
                            current_df = current_df.loc[current_df[element[0]] < float(element[2])]
                        else:
                            current_df = current_df.loc[current_df[element[0]] >= float(element[2])]
                        current_df.reset_index(drop=True, inplace=True)
                ### keep df in checked box ###
                if len(para_checklist) > 0:
                    and_list = []
                    for i in range(len(self.para_keys_list)):
                        key = self.para_keys_list[i]
                        or_list = []
                        for element in para_checklist[i]:
                            if element == 'True':element = True
                            elif element == 'False':element = False
                            _list = current_df[key] == element
                            or_list.append(_list)
                        or_list = np.logical_or.reduce(or_list)
                        and_list.append(or_list)
                    and_list = np.logical_and.reduce(and_list)

                    df_checked = current_df.loc[pd.DataFrame(and_list, columns=['check'])['check']].reset_index(drop=True).copy()
                else:
                    df_checked = current_df.copy()

                graph_df = components.generate_sorted_df(sort_method, df_checked, number_of_curves)
                self.graph_df = graph_df
                fig_line = components.generate_main_chart(graph_df, self.backtest_name, self.equity_curve_folder, self.para_keys_list)

                # Disable stra_alys_chart
                stra_alys_chart_btn_text = 'Strategy alysis >'
                self.chart_type = 'main_chart'

            return fig_line, filter_div, filter_dropdown_div,filter_input_div,_add_filter_save_btn_style, \
                   None, main_chart_btn_text, stra_alys_chart_btn_text, main_chart_area_style


        # Click on Chart 1 line
        @app.callback(
            Output(component_id='performance_matrix', component_property='children'),
            Output('stra_alys_chart_btn', 'style'),
            Input('line_chart', 'clickData'),
            State(component_id='performance_matrix', component_property='children'),
        )
        def update_matrix(clickData,performance_matrix):
            save_btn_style = {'text-align': 'right','color':'grey','font-size':'14px'}
            self.init_chart = False

            if clickData:
                if self.chart_type == 'main_chart':
                    i = clickData['points'][0]['curveNumber'] - 1

                    self.line_selected = i
                    save_btn_style = {'text-align': 'right','cursor': 'pointer','font-size':'14px'}

                    performance_matrix = components.update_performance_matrix(self.init_chart,
                                                                              self.para_keys_list,
                                                                              self.graph_df.iloc[[self.line_selected]].copy(),
                                                                              self.line_selected
                                                                              )

                    self.save_clicks = 0 # Needed for save btn click tracking


            return performance_matrix, save_btn_style


        # Select All btn
        @app.callback(
            Output({'type': 'para-checklist', 'index': ALL}, 'value'),
            [Input("all-or-none", "value")],
            State({'type': 'para-checklist', 'index': ALL}, 'value'),
        )
        def select_all_none(selected_all, options):

            if selected_all == None:
                pass
            elif selected_all == ['All']:
                if self.select_all_status == False:
                    options[0] = code_list
                    self.select_all_status = True
            else:
                if self.select_all_status == True:
                    options[0] = []
                    self.select_all_status = False

            return options


        # Save btn
        @app.callback(
            Output('save_string', "children"),
            Output('save_btn', "style"),
            Input('save_btn', "n_clicks"),
        )
        def save_btn(save_clicks):

            if self.line_selected >= 0:
                strategy_to_saved_df = self.graph_df.iloc[[self.line_selected]].copy().reset_index(drop=True)
            else:
                strategy_to_saved_df = pd.DataFrame({'ref_code': [0]})
                save_btn_str = self.save_btn_str

            if not os.path.isfile('saved_strategies.parquet'):
                strategy_to_saved_df.to_parquet('saved_strategies.parquet')

            save_btn_aval = None
            save_btn_style = {}

            if not self.init_chart:
                if not save_clicks:

                    save_btn_str = '--'
                    save_btn_style = {'font-size': '15px', 'margin-left': '20px', 'margin-right': '30px',
                                    'text-align': 'center', 'border-radius': '5px',
                                    'background-color': 'Grey', 'color': 'black',
                                    }

                    if self.line_selected > -1:

                        ref_code = strategy_to_saved_df.iloc[0].ref_code

                        saved_stra_df = pd.read_parquet('saved_strategies.parquet')
                        if not ref_code in list(saved_stra_df['ref_code']):
                            save_btn_aval = True
                        else:
                            save_btn_aval = False

                ##### when user click save button #####
                elif save_clicks:
                    if save_clicks > self.save_clicks:
                        self.save_clicks = save_clicks

                        if self.line_selected > -1:
                            saved_stra_df = pd.read_parquet('saved_strategies.parquet')
                            ref_code      = strategy_to_saved_df.iloc[0].ref_code
                            if ref_code in list(saved_stra_df['ref_code']):
                                if self.save_btn_str == 'Unsave Curve':
                                    strategy_to_saved_df = saved_stra_df[saved_stra_df['ref_code'] != ref_code]
                                save_btn_aval = True

                            else:
                                strategy_to_saved_df = pd.concat([saved_stra_df, strategy_to_saved_df])
                                save_btn_aval = False

                            strategy_to_saved_df = strategy_to_saved_df[strategy_to_saved_df['ref_code'] != 0]
                            strategy_to_saved_df.to_parquet('saved_strategies.parquet')


            if save_btn_aval is not None:
                if save_btn_aval:
                    save_btn_str = 'Save Curve'
                    save_btn_style = {'font-size': '15px', 'margin-left': '20px', 'margin-right': '30px',
                                    'text-align': 'center', 'border-radius': '5px', 'cursor': 'pointer',
                                    'background-color': 'Yellow', 'color': 'black',
                                    }
                elif not save_btn_aval:
                    save_btn_str = 'Unsave Curve'
                    save_btn_style = {'font-size': '15px', 'margin-left': '20px', 'margin-right': '30px',
                                    'text-align': 'center', 'border-radius': '5px', 'cursor': 'pointer',
                                    'background-color': 'Magenta', 'color': 'white',
                                    }

            self.save_btn_str = save_btn_str

            return save_btn_str, save_btn_style

        return app