# -*- coding: utf-8 -*-
#
# Licensed under the terms of the BSD 3-Clause
# (see plotpy/LICENSE for details)

"""
SelectPointTool test

This plotpy tool provide a MATLAB-like "ginput" feature.
"""

# guitest: show

from guidata.qthelpers import qt_app_context
from numpy import linspace, sin

from plotpy.builder import make
from plotpy.config import _
from plotpy.tools import SelectPointTool


def callback_function(tool):
    print("Current coordinates:", tool.get_coordinates())


def get_point(*args):
    """
    Plot curves and return selected point(s) coordinates
    """
    win = make.dialog(
        wintitle=_("Select one point then press OK to accept"),
        edit=True,
        type="curve",
    )
    default = win.manager.add_tool(
        SelectPointTool,
        title="Test",
        on_active_item=True,
        mode="reuse",
        end_callback=callback_function,
    )
    default.activate()
    plot = win.manager.get_plot()
    for cx, cy in args:
        item = make.mcurve(cx, cy)
        plot.add_item(item)
    plot.set_active_item(item)
    plot.unselect_item(item)
    win.show()
    return win, default.get_coordinates()


def test_get_point():
    """Test"""
    with qt_app_context(exec_loop=True):
        x = linspace(-10, 10, 500)
        y = 0.25 * sin(sin(sin(x * 0.5)))
        x2 = linspace(-10, 10, 200)
        y2 = sin(sin(sin(x2)))
        _persist_dialog, coordinates = get_point((x, y), (x2, y2), (x, sin(2 * y)))
        print(coordinates)


if __name__ == "__main__":
    test_get_point()
