[![made-with-python](https://img.shields.io/badge/Made%20with-Python-1f425f.svg)](https://www.python.org/)
![code-coverage](https://github.com/ElucidataInc/polly-python-code/blob/badges_do_not_delete/badges/badge.svg)
![Linting](https://img.shields.io/badge/Linting-Black-green)
![Version](https://img.shields.io/badge/python-3.7%2B-blue)

# About Polly Library

This package is intended to be used by Polly users - bioinformaticians, data scientists, and life science researchers - working in drug discovery and development.

# Installation

Polly-python can be installed by running:

```python
pip install polly-python
```
 
# Key features:

* Discover biomedical datasets specific to their research requirements by querying omixatlas which have a well-defined schema and curated metadata fields. 
* Expanding the query by using ontological mappings for diseases.
* Download the datasets of interest and use them for further enrichment and analysis using other open-source bash, R and Python packages commonly used in life-science research.
* Seamlessly interact with the Schema of the OmixAtlas by using fetch, update, and post functions.
* Create new Workspaces and fetch the list of existing ones.
* Upload and Download files and folders from Workspace.
* Save dataset of interest from OmixAtlas to Workspace.

# Get Started

* Examples of characteristics and functions of polly-python can be found as Jupyter Notebook [here](https://github.com/ElucidataInc/polly-python). 
* Full documentation available [here](https://docs.elucidata.io/OmixAtlas/Polly%20Python.html).

# Contributing Guidelines

* Refer to the `CONTRIBUTING.md` file for detailed information

# Contacts
If you have questions, suggestions or problems, feel free to open an issue [here](https://github.com/ElucidataInc/polly-python/issues).

You can contact us at:
* kapil.kumar@elucidata.io
* jainik.dedhia@elucidata.io
