from typing import TypedDict, Literal, Any, TypeAlias

class DutchAddressResult(TypedDict):
    street: str
    streetNen: str
    houseNumber: int
    houseNumberAddition: str | None
    postcode: str
    city: str
    cityShort: str
    cityId: str
    municipality: str
    municipalityShort: str
    municipalityId: str
    province: str
    rdX: int | None
    rdY: int | None
    latitude: float | None
    longitude: float | None
    bagNumberDesignationId: str | None
    bagAddressableObjectId: str | None
    addressType: str
    purposes: list[str] | None
    surfaceArea: int | None
    houseNumberAdditions: list[str]

class AutocompleteMatch(TypedDict):
    value: str
    label: str
    description: str
    precision: str
    context: str
    highlights: list[list[int]]

class AutocompleteResult(TypedDict):
    newContext: str | None
    matches: list[AutocompleteMatch]

class AutocompleteAddress(TypedDict):
    country: str
    locality: str
    street: str
    postcode: str
    building: str
    buildingNumber: int | None
    buildingNumberAddition: str | None

class AddressLocation(TypedDict):
    latitude: float
    longitude: float
    precision: Literal['Address', 'Street', 'PostalCode', 'Locality']

class AddressCountry(TypedDict):
    name: str
    iso3Code: str
    iso2Code: str

AddressDetails: TypeAlias = dict[str, Any]

class AutocompleteAddressResult(TypedDict):
    language: str
    address: AutocompleteAddress
    mailLines: list[str]
    location: AddressLocation | None
    isPoBox: bool
    country: AddressCountry
    details: AddressDetails

class SupportedCountry(TypedDict):
    name: str
    iso2: str
    iso3: str

class DutchAddressDistanceResult(TypedDict):
    address: DutchAddressResult
    distance: float

class DutchPostcodeRange(TypedDict):
    street: str
    streetNen: str
    startHouseNumber: int
    endHouseNumber: int
    houseNumberType: str
    city: str
    cityShort: str
    cityId: str
    municipality: str
    municipalityShort: str
    municipalityId: str
    province: str

class ValidationMatchStatus(TypedDict):
    grade: str
    validationLevel: str
    isAmbiguous: bool

class ValidationMatchAddress(TypedDict):
    country: str
    locality: str | None
    street: str | None
    postcode: str | None
    building: str | None
    buildingNumber: int | None
    buildingNumberAddition: str | None
    region: str | None

class ValidationMatch(TypedDict):
    status: ValidationMatchStatus
    language: str
    address: ValidationMatchStatus
    mailLines: list[str]
    location: AddressLocation | None
    isPoBox: bool
    country: AddressCountry
    details: AddressDetails | None

class ValidationResult(TypedDict):
    country: AddressCountry
    matches: list[ValidationMatch]

class ClientAccount(TypedDict):
    accountId: int
    key: str
    secret: str

class AccountSubscription(TypedDict):
    startDate: str
    limit: int
    usage: int

class AccountInfo(TypedDict):
    name: str
    hasAccess: bool
    countries: list[str]
    adminEmail: str
    contactEmail: str
    subscription: AccountSubscription
