# OpenFeature provider in Python for Posthog
```bash
pip install posthog-openfeature-provider-posthog
```

## License

This project is licensed under the **Mozilla Public License 2.0 (MPL-2.0)**.

You may use, modify, and distribute this library under the terms of the MPL-2.0.
Contributions that modify files in this library must be made available under
the same license, but it can be linked or combined with proprietary software.

See the [LICENSE](./LICENSE) file or the [official MPL 2.0 text](https://www.mozilla.org/en-US/MPL/2.0/)
for full terms.


## Development
Requies uv >= 0.9
```bash
uv sync --group dev
uv run ruff format
uv run ruff check --fix
uv run mypy src
```
## Testing
Requies uv >= 0.9
```bash
uv sync --group test
uv run pytest
uv run pytest -m unit # only unit tests
uv run pytest -m integration # only integration tests
```
