# # coding=utf-8
# # Copyright 2022 HuggingFace Inc.
# #
# # Licensed under the Apache License, Version 2.0 (the "License");
# # you may not use this file except in compliance with the License.
# # You may obtain a copy of the License at
# #
# #     http://www.apache.org/licenses/LICENSE-2.0
# #
# # Unless required by applicable law or agreed to in writing, software
# # distributed under the License is distributed on an "AS IS" BASIS,
# # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# # See the License for the specific language governing permissions and
# # limitations under the License.

# import gc
# import unittest

# import numpy as np
# import paddle

# from ppdiffusers import StableDiffusionKDiffusionPipeline
# from ppdiffusers.utils import slow


# @slow
# class StableDiffusionPipelineIntegrationTests(unittest.TestCase):
#     def tearDown(self):
#         # clean up the VRAM after each test
#         super().tearDown()
#         gc.collect()
#         paddle.device.cuda.empty_cache()

#     def test_stable_diffusion_1(self):
#         sd_pipe = StableDiffusionKDiffusionPipeline.from_pretrained("CompVis/stable-diffusion-v1-4")
#         sd_pipe.set_progress_bar_config(disable=None)

#         sd_pipe.set_scheduler("sample_euler")

#         prompt = "A painting of a squirrel eating a burger"
#         generator = paddle.Generator().manual_seed(0)
#         output = sd_pipe([prompt], generator=generator, guidance_scale=9.0, num_inference_steps=20, output_type="np")

#         image = output.images

#         image_slice = image[0, -3:, -3:, -1]

#         assert image.shape == (1, 512, 512, 3)
#         expected_slice = np.array([0.8887, 0.915, 0.91, 0.894, 0.909, 0.912, 0.919, 0.925, 0.883])
#         assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-2

#     def test_stable_diffusion_2(self):
#         sd_pipe = StableDiffusionKDiffusionPipeline.from_pretrained("stabilityai/stable-diffusion-2-1-base")
#         sd_pipe.set_progress_bar_config(disable=None)

#         sd_pipe.set_scheduler("sample_euler")

#         prompt = "A painting of a squirrel eating a burger"
#         generator = paddle.Generator().manual_seed(0)
#         output = sd_pipe([prompt], generator=generator, guidance_scale=9.0, num_inference_steps=20, output_type="np")

#         image = output.images

#         image_slice = image[0, -3:, -3:, -1]

#         assert image.shape == (1, 512, 512, 3)
#         expected_slice = np.array(
#             [0.826810, 0.81958747, 0.8510199, 0.8376758, 0.83958465, 0.8682068, 0.84370345, 0.85251087, 0.85884345]
#         )
#         assert np.abs(image_slice.flatten() - expected_slice).max() < 1e-2
